/*
 * Copyright (c) 2010,2011 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.app.views.layercomp;

import java.util.List;

import ch.kuramo.javie.app.views.LayerCompositionView;
import ch.kuramo.javie.core.LightLayer;
import ch.kuramo.javie.core.LightType;
import ch.kuramo.javie.core.Util;

public class LightTransformElement extends Element {

	private final LightLayer layer;

	private LightType type;

	private final List<LayerAnimatableValueElement> children = Util.newList();


	public LightTransformElement(LayerElement parent) {
		super(parent);
		this.layer = (LightLayer) parent.layer;
	}

	public String getColumnText(int columnIndex) {
		switch (columnIndex) {
			case LayerCompositionView.NAME_COL:
				return "トランスフォーム";

			default:
				return null;
		}
	}

	@Override
	public boolean hasChildren() {
		return true;
	}

	@Override
	public Element[] getChildren() {
		LightType currentType = layer.getLightType();

		if (currentType == type && children.size() > 0) {
			return children.toArray(new Element[children.size()]);
		}

		children.clear();
		type = currentType;

		switch (type) {
			case PARALLEL:
				createChildElement("pointOfInterest", "目標点");
				createChildElement("position", "位置");
				break;

			case SPOT:
				createChildElement("pointOfInterest", "目標点");
				createChildElement("position", "位置");
				createChildElement("orientation", "方向", "°");
				createChildElement("rotationX", "X 回転", "°");
				createChildElement("rotationY", "Y 回転", "°");
				createChildElement("rotationZ", "Z 回転", "°");
				break;

			case POINT:
				createChildElement("position", "位置");
				break;

			case AMBIENT:
				break;
		}

		return children.toArray(new Element[children.size()]);
	}

	private void createChildElement(String property, String name) {
		children.add(LayerAnimatableValueElement.forSimpleProperty(this, layer, property, name, null));
	}

	private void createChildElement(String property, String name, String unit) {
		children.add(LayerAnimatableValueElement.forSimpleProperty(this, layer, property, name, unit));
	}

}
