/*
 * Copyright (c) 2009,2010 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.core;

import java.util.Set;
import java.util.SortedMap;

import ch.kuramo.javie.api.IObjectArray;
import ch.kuramo.javie.api.Time;

public interface AnimatableValue<V> extends Expressioner<V>, Expressionee {

	V value(CoreContext context);

	V valueAtTime(Time time, CoreContext context);

	void values(
			IObjectArray<V> values, Time sampleDuration, int animationRate,
			CoreContext context);

	void valuesAtTime(
			IObjectArray<V> values, Time sampleDuration, int animationRate,
			Time time, CoreContext context);

	V getStaticValue();

	boolean hasKeyframe();

	Keyframe<V> getKeyframe(Time time);

	SortedMap<Time, Keyframe<V>> getKeyframeMap();

	Keyframe<V> putKeyframe(Keyframe<V> keyframe);

	Keyframe<V> putKeyframe(Time time, V value, Interpolation interpolation);

	Keyframe<V> removeKeyframe(Time time);

	void clearKeyframes();

	void clearKeyframes(V staticValue);

	void reset();

	void reset(V staticValue);

	String getExpression();

	void setExpression(String expression);

	Set<Interpolation> getAvailableInterpolations();

	Interpolation getDefaultInterpolation();

}
