/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core;

import ch.kuramo.javie.api.IAnimatableVec2d;
import ch.kuramo.javie.api.Vec2d;
import ch.kuramo.javie.api.Vec3d;
import ch.kuramo.javie.core.ArithmeticalAnimatableValue;
import ch.kuramo.javie.core.CoreContext;
import ch.kuramo.javie.core.Keyframe;
import ch.kuramo.javie.core.exprelems.Vec2dProperty;
import ch.kuramo.javie.core.exprelems.Vec3dProperty;
import java.util.Collection;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Wrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnimatableVec2d
extends ArithmeticalAnimatableValue<Vec2d>
implements IAnimatableVec2d {
    public AnimatableVec2d(Vec2d staticValue, Collection<Keyframe<Vec2d>> keyframes, String expression) {
        super(staticValue, keyframes, expression, Vec2d.NEGATIVE_INFINITY, Vec2d.POSITIVE_INFINITY);
    }

    public AnimatableVec2d(Vec2d defaultValue) {
        super(defaultValue, Vec2d.NEGATIVE_INFINITY, Vec2d.POSITIVE_INFINITY);
    }

    public AnimatableVec2d(Vec2d defaultValue, Vec2d minValue, Vec2d maxValue) {
        super(defaultValue, minValue, maxValue);
    }

    @Override
    public Vec2d clamp(Vec2d value) {
        return Vec2d.min((Vec2d)Vec2d.max((Vec2d)value, (Vec2d)((Vec2d)this._minValue)), (Vec2d)((Vec2d)this._maxValue));
    }

    @Override
    public Vec2d jsToJava(Object jsValue) {
        if (jsValue instanceof Wrapper) {
            Object javaObj = ((Wrapper)jsValue).unwrap();
            if (javaObj instanceof Vec2dProperty) {
                javaObj = ((Vec2dProperty)javaObj).getValue();
            } else if (javaObj instanceof Vec3dProperty) {
                javaObj = ((Vec3dProperty)javaObj).getValue();
            }
            if (javaObj instanceof Vec2d) {
                return (Vec2d)javaObj;
            }
            if (javaObj instanceof Vec3d) {
                Vec3d v3d = (Vec3d)javaObj;
                return new Vec2d(v3d.x, v3d.y);
            }
            if (javaObj instanceof Object[]) {
                Object[] value = (Object[])javaObj;
                double[] array = new double[2];
                int i = 0;
                int n = Math.min(2, value.length);
                while (i < n) {
                    array[i] = (Double)Context.jsToJava((Object)value[i], Double.TYPE);
                    ++i;
                }
                return this.valueOf(array);
            }
        } else {
            if (jsValue instanceof NativeArray) {
                double[] array = (double[])Context.jsToJava((Object)jsValue, double[].class);
                if (array.length < 2) {
                    double[] tmp = array;
                    array = new double[2];
                    int i = 0;
                    while (i < tmp.length) {
                        array[i] = tmp[i];
                        ++i;
                    }
                }
                return this.valueOf(array);
            }
            if (jsValue == null) {
                return Vec2d.ZERO;
            }
        }
        double d = (Double)Context.jsToJava((Object)jsValue, Double.TYPE);
        return new Vec2d(d, d);
    }

    @Override
    protected double[] toArray(Vec2d value) {
        return new double[]{value.x, value.y};
    }

    @Override
    protected Vec2d valueOf(double[] d) {
        return new Vec2d(d[0], d[1]);
    }

    public Scriptable createExpressionElement(final CoreContext context) {
        Vec2dProperty v2p = new Vec2dProperty(){

            public Vec2d getValue() {
                return (Vec2d)AnimatableVec2d.this.value(context);
            }

            public Vec2d valueAtTime(double t) {
                return (Vec2d)AnimatableVec2d.this.valueAtTime(t, context);
            }
        };
        return context.toNativeJavaObject(v2p, null);
    }
}

