/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core;

import ch.kuramo.javie.api.IObjectArray;
import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.core.AbstractAnimatableValue;
import ch.kuramo.javie.core.CoreContext;
import ch.kuramo.javie.core.Interpolation;
import ch.kuramo.javie.core.Keyframe;
import ch.kuramo.javie.core.Util;
import ch.kuramo.javie.core.WrappedOperation;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import net.arnx.jsonic.JSONHint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ArithmeticalAnimatableValue<V>
extends AbstractAnimatableValue<V> {
    protected V _minValue;
    protected V _maxValue;
    private static final Set<Interpolation> INTERPOLATIONS = Util.unmodifiableSet(Interpolation.HOLD, Interpolation.LINEAR, Interpolation.CATMULL_ROM);

    public ArithmeticalAnimatableValue(V staticValue, Collection<Keyframe<V>> keyframes, String expression, V minValue, V maxValue) {
        super(staticValue, keyframes, expression);
        this._minValue = minValue;
        this._maxValue = maxValue;
    }

    public ArithmeticalAnimatableValue(V defaultValue, V minValue, V maxValue) {
        super(defaultValue);
        this._minValue = minValue;
        this._maxValue = maxValue;
    }

    @Override
    public void copyConfigurationFrom(AbstractAnimatableValue<V> src) {
        super.copyConfigurationFrom(src);
        ArithmeticalAnimatableValue src2 = (ArithmeticalAnimatableValue)src;
        this._minValue = src2._minValue;
        this._maxValue = src2._maxValue;
    }

    public abstract V clamp(V var1);

    @Override
    public V value(CoreContext context) {
        return this.clamp(super.value(context));
    }

    @Override
    public V valueAtTime(Time time, CoreContext context) {
        return this.clamp(super.valueAtTime(time, context));
    }

    @Override
    public void valuesAtTime(IObjectArray<V> values, final Time sampleDuration, final int animationRate, final Time time, final CoreContext context) {
        final Object[] array = (Object[])values.getArray();
        final int len = values.getLength();
        if (this._expression != null && !context.checkCyclicEvaluation(this)) {
            try {
                context.saveAndExecute(new WrappedOperation<Object>(){

                    @Override
                    public Object execute() {
                        Time t1 = null;
                        Time t2 = time;
                        double[] v1 = null;
                        context.setTime(t2);
                        double[] v2 = ArithmeticalAnimatableValue.this.toArray(context.evaluateExpression(ArithmeticalAnimatableValue.this));
                        int i = 0;
                        while (i < len) {
                            if (i % animationRate == 0) {
                                t1 = t2;
                                v1 = v2;
                                t2 = time.add(new Time(sampleDuration.timeValue * (long)(i + animationRate), sampleDuration.timeScale));
                                context.setTime(t2);
                                v2 = ArithmeticalAnimatableValue.this.toArray(context.evaluateExpression(ArithmeticalAnimatableValue.this));
                            }
                            array[i] = ArithmeticalAnimatableValue.this.valueOf(ArithmeticalAnimatableValue.this.linear(v1, v2, t1, t2, time.add(new Time(sampleDuration.timeValue * (long)i, sampleDuration.timeScale))));
                            ++i;
                        }
                        return null;
                    }
                });
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Time t1 = null;
        Time t2 = time;
        double[] v1 = null;
        double[] v2 = this.toArray(this.interpolate(t2));
        int i = 0;
        while (i < len) {
            if (i % animationRate == 0) {
                t1 = t2;
                v1 = v2;
                t2 = time.add(new Time(sampleDuration.timeValue * (long)(i + animationRate), sampleDuration.timeScale));
                v2 = this.toArray(this.interpolate(t2));
            }
            array[i] = this.valueOf(this.linear(v1, v2, t1, t2, time.add(new Time(sampleDuration.timeValue * (long)i, sampleDuration.timeScale))));
            ++i;
        }
    }

    @Override
    protected V interpolate(Time time, Keyframe<V> k1, Keyframe<V> k2, Iterator<Map.Entry<Time, Keyframe<V>>> tail) {
        switch (k1.interpolation) {
            case LINEAR: {
                return this.valueOf(this.linear(this.toArray(k1.value), this.toArray(k2.value), k1.time, k2.time, time));
            }
            case CATMULL_ROM: {
                SortedMap headMap = this._keyframes.headMap(k1.time);
                Keyframe k0 = !headMap.isEmpty() ? (Keyframe)headMap.get(headMap.lastKey()) : k1;
                Keyframe<V> k3 = tail.hasNext() ? tail.next().getValue() : k2;
                return this.valueOf(this.catmullRom(this.toArray(k0.value), this.toArray(k1.value), this.toArray(k2.value), this.toArray(k3.value), k1.time, k2.time, time));
            }
        }
        return super.interpolate(time, k1, k2, tail);
    }

    protected abstract double[] toArray(V var1);

    protected abstract V valueOf(double[] var1);

    protected double[] linear(double[] p1, double[] p2, Time time1, Time time2, Time time) {
        double[] result = new double[p1.length];
        int i = 0;
        int n = result.length;
        while (i < n) {
            double s1 = time1.toSecond();
            double s2 = time2.toSecond();
            double s = time.toSecond();
            double t = (s - s1) / (s2 - s1);
            result[i] = (p2[i] - p1[i]) * t + p1[i];
            ++i;
        }
        return result;
    }

    protected double[] catmullRom(double[] p0, double[] p1, double[] p2, double[] p3, Time time1, Time time2, Time time) {
        double[] result = new double[p0.length];
        int i = 0;
        int n = result.length;
        while (i < n) {
            double s1 = time1.toSecond();
            double s2 = time2.toSecond();
            double s = time.toSecond();
            double t = (s - s1) / (s2 - s1);
            double tt = t * t;
            double ttt = tt * t;
            double v0 = (p2[i] - p0[i]) * 0.5;
            double v1 = (p3[i] - p1[i]) * 0.5;
            result[i] = (2.0 * p1[i] - 2.0 * p2[i] + v0 + v1) * ttt + (-3.0 * p1[i] + 3.0 * p2[i] - 2.0 * v0 - v1) * tt + v0 * t + p1[i];
            ++i;
        }
        return result;
    }

    @Override
    @JSONHint(ignore=true)
    public Set<Interpolation> getAvailableInterpolations() {
        return INTERPOLATIONS;
    }

    @Override
    @JSONHint(ignore=true)
    public Interpolation getDefaultInterpolation() {
        return Interpolation.LINEAR;
    }
}

