/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal;

import ch.kuramo.javie.api.AudioMode;
import ch.kuramo.javie.api.IArray;
import ch.kuramo.javie.api.IAudioBuffer;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.services.IArrayPools;
import ch.kuramo.javie.core.JavieRuntimeException;
import ch.kuramo.javie.core.MediaOptions;
import ch.kuramo.javie.core.MediaSource;
import ch.kuramo.javie.core.services.AudioRenderSupport;
import ch.kuramo.javie.core.services.RenderContext;
import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaSoundSource
implements MediaSource {
    private static final Logger _logger = LoggerFactory.getLogger(JavaSoundSource.class);
    private File _file;
    private Time _duration;
    private AudioMode _audioMode;
    private AudioInputStream _stream;
    private long _streamPosition;
    @Inject
    private RenderContext _context;
    @Inject
    private AudioRenderSupport _arSupport;
    @Inject
    private IArrayPools _arrayPools;

    public boolean initialize(File file) {
        this._file = file;
        try {
            AudioInputStream stream = AudioSystem.getAudioInputStream(file);
            try {
                int frameRateInt;
                float frameRate;
                long numFrames = stream.getFrameLength();
                AudioFormat format = stream.getFormat();
                if ((format.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED) || format.getEncoding().equals(AudioFormat.Encoding.PCM_UNSIGNED)) && numFrames * (long)format.getFrameSize() > file.length()) {
                    numFrames /= (long)format.getFrameSize();
                }
                if ((frameRate = format.getFrameRate()) - (float)(frameRateInt = (int)frameRate) != 0.0f) {
                    _logger.warn("frame rate is not integer: " + frameRate);
                }
                this._duration = new Time(numFrames, frameRateInt);
            }
            finally {
                stream.close();
            }
        }
        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    public void dispose() {
        this.closeStream();
    }

    private void closeStream() {
        if (this._stream != null) {
            try {
                this._stream.close();
            }
            catch (IOException e) {
                _logger.warn("failed to close AudioInputStream", (Throwable)e);
            }
            this._stream = null;
        }
        this._streamPosition = 0L;
    }

    public synchronized IAudioBuffer getAudioChunk(Time mediaTime, MediaOptions options) {
        try {
            AudioMode audioMode = this._context.getAudioMode();
            long frameNumber = mediaTime.toFrameNumber(audioMode.sampleDuration);
            if (-frameNumber >= (long)this._context.getAudioFrameCount() || !mediaTime.before(this._duration)) {
                IAudioBuffer ab = this._arSupport.createAudioBuffer();
                this._arSupport.clear(ab);
                return ab;
            }
            if (audioMode != this._audioMode || (long)audioMode.frameSize * frameNumber != this._streamPosition) {
                this.closeStream();
            }
            if (this._stream == null) {
                this._stream = this.createAudioInputStream();
            }
            return this.readAudioData(frameNumber);
        }
        catch (IOException e) {
            throw new JavieRuntimeException(e);
        }
        catch (UnsupportedAudioFileException e) {
            throw new JavieRuntimeException(e);
        }
    }

    private AudioInputStream createAudioInputStream() throws IOException, UnsupportedAudioFileException {
        this._audioMode = this._context.getAudioMode();
        int bits = this._audioMode.sampleSize * 8;
        int ch = this._audioMode.channels;
        boolean bigEndian = ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN);
        AudioInputStream s1 = AudioSystem.getAudioInputStream(this._file);
        AudioFormat f2 = new AudioFormat(s1.getFormat().getSampleRate(), bits, ch, true, bigEndian);
        AudioInputStream s2 = AudioSystem.getAudioInputStream(f2, s1);
        AudioFormat f3 = new AudioFormat(this._audioMode.sampleRate, bits, ch, true, bigEndian);
        return AudioSystem.getAudioInputStream(f3, s2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IAudioBuffer readAudioData(long frameNumber) throws IOException {
        IAudioBuffer ab = this._arSupport.createAudioBuffer();
        AudioMode audioMode = ab.getAudioMode();
        Object data = ab.getData();
        int dataOffset = 0;
        int dataLength = ab.getDataLength();
        int lengthInBytes = dataLength * audioMode.sampleSize;
        if (this._streamPosition == 0L) {
            if (frameNumber > 0L) {
                long skipped;
                long skip = (long)audioMode.frameSize * frameNumber;
                this._streamPosition = skipped = this._stream.skip(skip / (long)audioMode.sampleRate * (long)audioMode.sampleRate);
                if ((skip -= skipped) > 0L) {
                    IArray array = this._arrayPools.getByteArray((int)skip);
                    try {
                        do {
                            if ((skipped = (long)this._stream.read((byte[])array.getArray(), 0, (int)skip)) == -1L) continue;
                            this._streamPosition += skipped;
                            skip -= skipped;
                        } while (skipped != -1L && skip > 0L);
                    }
                    finally {
                        array.release();
                    }
                }
                if (skip != 0L) {
                    _logger.warn(String.format("skip failed: frameNumber=%d, skip=%d", frameNumber, skip));
                    this.closeStream();
                    this._arSupport.clear(ab);
                    return ab;
                }
            } else if (frameNumber < 0L) {
                this._arSupport.clear(ab, 0, (int)(-frameNumber));
                dataOffset = (int)(-frameNumber) * audioMode.channels;
                dataLength -= dataOffset;
                lengthInBytes -= dataOffset * audioMode.sampleSize;
            }
        }
        IArray array = this._arrayPools.getByteArray(lengthInBytes);
        try {
            int n;
            byte[] buffer = (byte[])array.getArray();
            int readBytes = 0;
            do {
                if ((n = this._stream.read(buffer, readBytes, lengthInBytes - readBytes)) == -1) {
                    Arrays.fill(buffer, readBytes, lengthInBytes, (byte)0);
                    break;
                }
                this._streamPosition += (long)n;
            } while ((readBytes += n) < lengthInBytes);
            switch (audioMode.dataType) {
                case SHORT: {
                    ByteBuffer.wrap(buffer, 0, lengthInBytes).order(ByteOrder.nativeOrder()).asShortBuffer().get((short[])data, dataOffset, dataLength);
                    return ab;
                }
                case INT: {
                    ByteBuffer.wrap(buffer, 0, lengthInBytes).order(ByteOrder.nativeOrder()).asIntBuffer().get((int[])data, dataOffset, dataLength);
                    return ab;
                }
                case FLOAT: {
                    int i = dataOffset;
                    while (i < dataLength) {
                        int value = buffer[i * 4] & 0xFF | (buffer[i * 4 + 1] & 0xFF) << 8 | (buffer[i * 4 + 2] & 0xFF) << 16 | (buffer[i * 4 + 3] & 0xFF) << 24;
                        ((float[])data)[i] = (float)value / 2.1474836E9f;
                        ++i;
                    }
                    return ab;
                }
            }
            throw new UnsupportedOperationException("unsupported AudioMode.DataType: " + audioMode.dataType);
        }
        finally {
            array.release();
        }
    }

    public boolean isVideoAvailable() {
        return false;
    }

    public boolean isAudioAvailable() {
        return true;
    }

    public Time getDuration(MediaOptions options) {
        return this._duration;
    }

    public Time getVideoFrameDuration(MediaOptions options) {
        throw new UnsupportedOperationException("video is not available");
    }

    public VideoBounds getVideoFrameBounds(MediaOptions options) {
        throw new UnsupportedOperationException("video is not available");
    }

    public IVideoBuffer getVideoFrame(Time mediaTime, MediaOptions options) {
        throw new UnsupportedOperationException("video is not available");
    }

    public MediaOptions validateOptions(MediaOptions options) {
        if (options == null) {
            options = new MediaOptions();
        } else {
            options = options.clone();
            options.clearAvailableOptions();
        }
        return options;
    }
}

