/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal;

import ch.kuramo.javie.api.ColorMode;
import ch.kuramo.javie.api.IAudioBuffer;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.core.AbstractComposition;
import ch.kuramo.javie.core.Camera;
import ch.kuramo.javie.core.CoreContext;
import ch.kuramo.javie.core.ExpressionScope;
import ch.kuramo.javie.core.Layer;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.LayerNature;
import ch.kuramo.javie.core.MediaItemLayer;
import ch.kuramo.javie.core.MediaLayer;
import ch.kuramo.javie.core.Project;
import ch.kuramo.javie.core.ProjectDecodeException;
import ch.kuramo.javie.core.SuperSampling;
import ch.kuramo.javie.core.TextLayer;
import ch.kuramo.javie.core.TrackMatte;
import ch.kuramo.javie.core.Util;
import ch.kuramo.javie.core.VideoLayerRenderer;
import ch.kuramo.javie.core.WrappedOperation;
import ch.kuramo.javie.core.annotations.ProjectElement;
import ch.kuramo.javie.core.internal.CameraImpl;
import ch.kuramo.javie.core.internal.LightSet;
import ch.kuramo.javie.core.internal.VideoLayerComposer;
import ch.kuramo.javie.core.services.AudioRenderSupport;
import ch.kuramo.javie.core.services.RenderContext;
import com.google.inject.Inject;
import com.google.inject.Injector;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ProjectElement(value="layerComposition")
public class LayerCompositionImpl
extends AbstractComposition
implements LayerComposition {
    private boolean _shyEnabled = false;
    private boolean _frameBlendEnabled = false;
    private boolean _motionBlurEnabled = false;
    private double _motionBlurShutterAngle = 180.0;
    private double _motionBlurShutterPhase = -90.0;
    private int _motionBlurSamples = 16;
    private SuperSampling _superSampling = SuperSampling.SS_NONE;
    private List<Layer> _layers = Util.newList();
    @Inject
    private RenderContext _context;
    @Inject
    private AudioRenderSupport _arSupport;
    @Inject
    private Injector _injector;

    @Override
    public boolean isShyEnabled() {
        return this._shyEnabled;
    }

    @Override
    public void setShyEnabled(boolean shyEnabled) {
        this._shyEnabled = shyEnabled;
    }

    @Override
    public boolean isFrameBlendEnabled() {
        return this._frameBlendEnabled;
    }

    @Override
    public void setFrameBlendEnabled(boolean frameBlendEnabled) {
        this._frameBlendEnabled = frameBlendEnabled;
    }

    @Override
    public boolean isMotionBlurEnabled() {
        return this._motionBlurEnabled;
    }

    @Override
    public void setMotionBlurEnabled(boolean motionBlurEnabled) {
        this._motionBlurEnabled = motionBlurEnabled;
    }

    @Override
    public double getMotionBlurShutterAngle() {
        return this._motionBlurShutterAngle;
    }

    @Override
    public void setMotionBlurShutterAngle(double motionBlurShutterAngle) {
        this._motionBlurShutterAngle = motionBlurShutterAngle;
    }

    @Override
    public double getMotionBlurShutterPhase() {
        return this._motionBlurShutterPhase;
    }

    @Override
    public void setMotionBlurShutterPhase(double motionBlurShutterPhase) {
        this._motionBlurShutterPhase = motionBlurShutterPhase;
    }

    @Override
    public int getMotionBlurSamples() {
        return this._motionBlurSamples;
    }

    @Override
    public void setMotionBlurSamples(int motionBlurSamples) {
        this._motionBlurSamples = motionBlurSamples;
    }

    @Override
    public SuperSampling getSuperSampling() {
        return this._superSampling;
    }

    @Override
    public void setSuperSampling(SuperSampling superSampling) {
        this._superSampling = superSampling;
    }

    @Override
    public List<Layer> getLayers() {
        return this._layers;
    }

    public void setLayers(List<Layer> layers) {
        this._layers = layers;
    }

    @Override
    public Layer getLayer(String id) {
        for (Layer layer : this._layers) {
            if (!layer.getId().equals(id)) continue;
            return layer;
        }
        return null;
    }

    @Override
    public Layer getParentLayer(Layer layer) {
        String parentId = layer.getParentId();
        return parentId != null ? this.getLayer(parentId) : null;
    }

    @Override
    public void setParentLayer(Layer layer, Layer parent) {
        layer.setParentId(parent != null ? parent.getId() : null);
    }

    @Override
    public void afterDecode(Project p) throws ProjectDecodeException {
        for (Layer layer : this._layers) {
            layer.afterDecode(p, this);
        }
    }

    @Override
    public void prepareExpression(ExpressionScope scope) {
        scope.putExpressionElement("thisComp", this);
        for (Layer layer : this._layers) {
            layer.prepareExpression(scope.clone());
        }
    }

    @Override
    public IVideoBuffer renderVideoFrame() {
        this._context.setComposition(this);
        ColorMode colorMode = this.getColorMode();
        this._context.setColorMode(colorMode);
        Time time = this._context.getTime();
        if (this.isFrameDurationPreserved()) {
            Time frameDuration = this.getFrameDuration();
            time = Time.fromFrameNumber((long)time.toFrameNumber(frameDuration), (Time)frameDuration);
            this._context.setTime(time);
            this._context.setVideoFrameDuration(frameDuration);
        }
        this._context.setCamera((Camera)this._injector.getInstance(CameraImpl.class));
        this._context.setLights(((LightSet)this._injector.getInstance(LightSet.class)).getLights());
        VideoLayerComposer composer = (VideoLayerComposer)this._injector.getInstance(VideoLayerComposer.class);
        int i = 0;
        int n = this._layers.size();
        while (i < n) {
            Layer layer = this._layers.get(i);
            if (LayerNature.isVideoEnabled(layer) && !layer.getInPoint().after(time) && layer.getOutPoint().after(time) && layer instanceof MediaLayer) {
                Layer nextLayer;
                MediaLayer mediaLayer = (MediaLayer)layer;
                MediaLayer matteLayer = null;
                if (mediaLayer.getTrackMatte() != TrackMatte.NONE && i + 1 < n && (nextLayer = this._layers.get(i + 1)) instanceof MediaLayer) {
                    matteLayer = (MediaLayer)nextLayer;
                }
                composer.addLayerRenderers(this.createVideoRenderers(mediaLayer, matteLayer));
            }
            ++i;
        }
        return composer.compose();
    }

    @Override
    public List<VideoLayerRenderer> createCollapsedRenderers() {
        List<VideoLayerRenderer> list = Util.newList();
        this._context.setComposition(this);
        Time time = this._context.getTime();
        int i = 0;
        int n = this._layers.size();
        while (i < n) {
            Layer layer = this._layers.get(i);
            if (LayerNature.isVideoEnabled(layer) && !layer.getInPoint().after(time) && layer.getOutPoint().after(time) && layer instanceof MediaLayer) {
                Layer nextLayer;
                MediaLayer mediaLayer = (MediaLayer)layer;
                MediaLayer matteLayer = null;
                if (mediaLayer.getTrackMatte() != TrackMatte.NONE && i + 1 < n && (nextLayer = this._layers.get(i + 1)) instanceof MediaLayer) {
                    matteLayer = (MediaLayer)nextLayer;
                }
                list.addAll(this.createVideoRenderers(mediaLayer, matteLayer));
            }
            ++i;
        }
        return list;
    }

    private List<VideoLayerRenderer> createVideoRenderers(final MediaLayer layer, MediaLayer matteLayer) {
        List<VideoLayerRenderer> matteRenderers;
        TextLayer textLayer;
        List<Object> renderers = null;
        if (layer instanceof MediaItemLayer) {
            final MediaItemLayer miLayer = (MediaItemLayer)layer;
            if (LayerNature.isCTCR(miLayer) && miLayer.isPrecompositionLayer()) {
                renderers = this._context.saveAndExecute(new WrappedOperation<List<VideoLayerRenderer>>(){

                    @Override
                    public List<VideoLayerRenderer> execute() {
                        return miLayer.createCollapsedRenderers();
                    }
                });
            }
        } else if (layer instanceof TextLayer && LayerNature.isThreeD(textLayer = (TextLayer)layer) && textLayer.isPerCharacter3D()) {
            renderers = this._context.saveAndExecute(new WrappedOperation<List<VideoLayerRenderer>>(){

                @Override
                public List<VideoLayerRenderer> execute() {
                    return textLayer.createPerCharacter3DRenderers();
                }
            });
        }
        if (renderers == null) {
            VideoLayerRenderer.GeneralLayerRenderer r = this._context.saveAndExecute(new WrappedOperation<VideoLayerRenderer.GeneralLayerRenderer>(){

                @Override
                public VideoLayerRenderer.GeneralLayerRenderer execute() {
                    return layer.createVideoRenderer();
                }
            });
            renderers = Util.newList();
            if (r != null) {
                renderers.add(r);
            }
        }
        if (!renderers.isEmpty() && matteLayer != null && !(matteRenderers = this.createVideoRenderers(matteLayer, null)).isEmpty()) {
            VideoLayerRenderer.AbstractMatteLayerRenderers mlr = new VideoLayerRenderer.AbstractMatteLayerRenderers(){

                @Override
                public MediaLayer getLayer() {
                    return layer;
                }

                @Override
                public List<VideoLayerRenderer> getRenderers() {
                    return matteRenderers;
                }
            };
            for (VideoLayerRenderer videoLayerRenderer : renderers) {
                if (!(videoLayerRenderer instanceof VideoLayerRenderer.GeneralLayerRenderer)) continue;
                ((VideoLayerRenderer.GeneralLayerRenderer)videoLayerRenderer).addMatteId(mlr.getMatteId());
            }
            renderers.add(mlr);
        }
        return renderers;
    }

    @Override
    public IVideoBuffer getLayerVideoFrame(Layer layer, boolean rawSource) {
        if (this._context.getComposition() != this) {
            throw new IllegalStateException("this composition is not the context composition.");
        }
        if (layer == null) {
            throw new NullPointerException();
        }
        if (!this._layers.contains(layer)) {
            throw new IllegalArgumentException("no such layer found in this LayerComposition");
        }
        if (!LayerNature.isVideoNature(layer)) {
            return null;
        }
        if (rawSource) {
            if (layer instanceof MediaLayer) {
                final MediaLayer ml = (MediaLayer)layer;
                return this._context.saveAndExecute(new WrappedOperation<IVideoBuffer>(){

                    @Override
                    public IVideoBuffer execute() {
                        VideoLayerRenderer.GeneralLayerRenderer r = ml.createVideoRenderer();
                        if (r instanceof VideoLayerRenderer.NormalLayerRenderer) {
                            return ((VideoLayerRenderer.NormalLayerRenderer)r).render(false, LayerCompositionImpl.this._frameBlendEnabled);
                        }
                        return ((VideoLayerRenderer.CRLayerRenderer)r).render();
                    }
                });
            }
        } else {
            TextLayer textLayer;
            Time time = this._context.getTime();
            if (layer.getInPoint().after(time) || !layer.getOutPoint().after(time)) {
                return null;
            }
            if (layer instanceof MediaItemLayer) {
                final MediaItemLayer miLayer = (MediaItemLayer)layer;
                if (LayerNature.isCTCR(miLayer) && miLayer.isPrecompositionLayer()) {
                    return this._context.saveAndExecute(new WrappedOperation<IVideoBuffer>(){

                        @Override
                        public IVideoBuffer execute() {
                            LayerCompositionImpl.this._context.setCamera((Camera)LayerCompositionImpl.this._injector.getInstance(CameraImpl.class));
                            VideoLayerComposer composer = (VideoLayerComposer)LayerCompositionImpl.this._injector.getInstance(VideoLayerComposer.class);
                            composer.addLayerRenderers(miLayer.createCollapsedRenderers());
                            return composer.compose();
                        }
                    });
                }
            } else if (layer instanceof TextLayer && LayerNature.isThreeD(textLayer = (TextLayer)layer) && textLayer.isPerCharacter3D()) {
                return this._context.saveAndExecute(new WrappedOperation<IVideoBuffer>(){

                    @Override
                    public IVideoBuffer execute() {
                        LayerCompositionImpl.this._context.setCamera((Camera)LayerCompositionImpl.this._injector.getInstance(CameraImpl.class));
                        VideoLayerComposer composer = (VideoLayerComposer)LayerCompositionImpl.this._injector.getInstance(VideoLayerComposer.class);
                        composer.addLayerRenderers(textLayer.createPerCharacter3DRenderers());
                        return composer.compose();
                    }
                });
            }
            if (layer instanceof MediaLayer) {
                final MediaLayer ml = (MediaLayer)layer;
                return this._context.saveAndExecute(new WrappedOperation<IVideoBuffer>(){

                    @Override
                    public IVideoBuffer execute() {
                        LayerCompositionImpl.this._context.setCamera((Camera)LayerCompositionImpl.this._injector.getInstance(CameraImpl.class));
                        VideoLayerComposer composer = (VideoLayerComposer)LayerCompositionImpl.this._injector.getInstance(VideoLayerComposer.class);
                        composer.addLayerRenderer(ml.createVideoRenderer());
                        return composer.compose();
                    }
                });
            }
        }
        return null;
    }

    @Override
    public IAudioBuffer renderAudioChunk() {
        this._context.setComposition(this);
        ColorMode colorMode = this.getColorMode();
        this._context.setColorMode(colorMode);
        if (this.isFrameDurationPreserved()) {
            this._context.setVideoFrameDuration(this.getFrameDuration());
        }
        IAudioBuffer ab = null;
        Time time = this._context.getTime();
        Time chunkDuration = Time.fromFrameNumber((long)this._context.getAudioFrameCount(), (Time)this._context.getAudioMode().sampleDuration);
        for (Layer layer : this._layers) {
            MediaLayer al;
            IAudioBuffer alab;
            if (!LayerNature.isAudioEnabled(layer) || layer.getInPoint().after(time.add(chunkDuration)) || !layer.getOutPoint().after(time) || !(layer instanceof MediaLayer) || (alab = this._context.saveAndExecute(new WrappedOperation<IAudioBuffer>(al = (MediaLayer)layer){
                private final /* synthetic */ MediaLayer val$al;
                {
                    this.val$al = mediaLayer;
                }

                @Override
                public IAudioBuffer execute() {
                    return this.val$al.renderAudioChunk(false);
                }
            })) == null) continue;
            if (ab == null) {
                ab = alab;
                continue;
            }
            IAudioBuffer abOld = ab;
            try {
                ab = this._arSupport.mix(ab, alab);
            }
            finally {
                if (ab != abOld) {
                    abOld.dispose();
                }
                if (ab != alab) {
                    alab.dispose();
                }
            }
        }
        return ab;
    }

    @Override
    public IAudioBuffer getLayerAudioChunk(Layer layer, final boolean rawSource) {
        if (this._context.getComposition() != this) {
            throw new IllegalStateException("this composition is not the context composition.");
        }
        if (layer == null) {
            throw new NullPointerException();
        }
        if (!this._layers.contains(layer)) {
            throw new IllegalArgumentException("no such layer found in this LayerComposition");
        }
        if (!LayerNature.isAudioNature(layer)) {
            return null;
        }
        if (!rawSource) {
            Time time = this._context.getTime();
            Time chunkDuration = Time.fromFrameNumber((long)this._context.getAudioFrameCount(), (Time)this._context.getAudioMode().sampleDuration);
            if (layer.getInPoint().after(time.add(chunkDuration)) || !layer.getOutPoint().after(time)) {
                return null;
            }
        }
        if (layer instanceof MediaLayer) {
            final MediaLayer ml = (MediaLayer)layer;
            return this._context.saveAndExecute(new WrappedOperation<IAudioBuffer>(){

                @Override
                public IAudioBuffer execute() {
                    return ml.renderAudioChunk(rawSource);
                }
            });
        }
        return null;
    }

    @Override
    public Object createExpressionElement(CoreContext context) {
        return new LayerCompositionExpressionElement(context);
    }

    public class LayerCompositionExpressionElement {
        protected final CoreContext context;

        public LayerCompositionExpressionElement(CoreContext context) {
            this.context = context;
        }

        public Object layer(int index) {
            Layer layer = (Layer)LayerCompositionImpl.this._layers.get(LayerCompositionImpl.this._layers.size() - index);
            return this.context.getExpressionElement(layer);
        }

        public Object layer(String name) {
            ListIterator it = LayerCompositionImpl.this._layers.listIterator(LayerCompositionImpl.this._layers.size());
            while (it.hasPrevious()) {
                Layer layer = (Layer)it.previous();
                if (!layer.getName().equals(name)) continue;
                return this.context.getExpressionElement(layer);
            }
            return null;
        }

        public int getWidth() {
            return LayerCompositionImpl.this.getSize().width;
        }

        public int getHeight() {
            return LayerCompositionImpl.this.getSize().height;
        }
    }
}

