/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal;

import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.core.Layer;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.LayerNature;
import ch.kuramo.javie.core.Light;
import ch.kuramo.javie.core.LightLayer;
import ch.kuramo.javie.core.Util;
import ch.kuramo.javie.core.internal.LightImpl;
import ch.kuramo.javie.core.services.RenderContext;
import ch.kuramo.javie.core.services.VideoRenderSupport;
import com.google.inject.Inject;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LightSet {
    private final Set<Light> lights;

    @Inject
    LightSet(RenderContext context, VideoRenderSupport oldSupport) {
        LayerComposition comp = (LayerComposition)context.getComposition();
        Set<LightImpl> lights = Util.newSet();
        List<Layer> layers = comp.getLayers();
        Time time = context.getTime();
        ListIterator<Layer> it = layers.listIterator(layers.size());
        while (it.hasPrevious()) {
            Layer layer = it.previous();
            if (!(layer instanceof LightLayer) || !LayerNature.isVideoEnabled(layer) || layer.getInPoint().after(time) || !layer.getOutPoint().after(time)) continue;
            lights.add(new LightImpl((LightLayer)layer, context, oldSupport));
        }
        this.lights = Collections.unmodifiableSet(lights);
    }

    Set<Light> getLights() {
        return this.lights;
    }
}

