/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal;

import ch.kuramo.javie.core.JavieRuntimeException;
import com.jogamp.opengl.impl.macosx.cgl.CGL;
import com.jogamp.opengl.impl.macosx.cgl.MacOSXCGLDrawable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLContext;

public class MacOSXOpenGLPixelFormat {
    private static final Method methodGLCapabilities2NSPixelFormat;

    static {
        try {
            Class<?> clazz = Class.forName("com.jogamp.opengl.impl.macosx.cgl.MacOSXCGLGraphicsConfiguration");
            Method method = clazz.getDeclaredMethod("GLCapabilities2NSPixelFormat", GLCapabilitiesImmutable.class);
            method.setAccessible(true);
            methodGLCapabilities2NSPixelFormat = method;
        }
        catch (SecurityException e) {
            throw new JavieRuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new JavieRuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new JavieRuntimeException(e);
        }
    }

    public static long createPixelFormat(GLContext context) {
        GLCapabilitiesImmutable caps = ((MacOSXCGLDrawable)context.getGLDrawable()).getChosenGLCapabilities();
        try {
            return (Long)methodGLCapabilities2NSPixelFormat.invoke(null, caps);
        }
        catch (IllegalArgumentException e) {
            throw new JavieRuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new JavieRuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new JavieRuntimeException(e);
        }
    }

    public static void deletePixelFormat(long pixelFormat) {
        CGL.deletePixelFormat((long)pixelFormat);
    }

    private MacOSXOpenGLPixelFormat() {
    }
}

