/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal;

import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.core.AnimatableBoolean;
import ch.kuramo.javie.core.AnimatableDouble;
import ch.kuramo.javie.core.AnimatableInteger;
import ch.kuramo.javie.core.CoreContext;
import ch.kuramo.javie.core.ExpressionScope;
import ch.kuramo.javie.core.TARangeSelector;
import ch.kuramo.javie.core.TASelector;
import ch.kuramo.javie.core.annotations.ProjectElement;
import ch.kuramo.javie.core.internal.AbstractTASelector;
import ch.kuramo.javie.core.services.RenderContext;
import com.google.inject.Inject;
import java.util.Random;

@ProjectElement(value="TARangeSelector")
public class TARangeSelectorImpl
extends AbstractTASelector
implements TARangeSelector {
    private AnimatableDouble start = new AnimatableDouble((Double)0.0, 0.0, 100.0);
    private AnimatableDouble end = new AnimatableDouble((Double)100.0, 0.0, 100.0);
    private AnimatableDouble offset = new AnimatableDouble((Double)0.0, -100.0, 100.0);
    private AbstractTASelector.AnimatableMode mode = new AbstractTASelector.AnimatableMode(TASelector.Mode.ADD);
    private AnimatableDouble amount = new AnimatableDouble((Double)100.0, -100.0, 100.0);
    private TARangeSelector.Shape shape = TARangeSelector.Shape.SQUARE;
    private AnimatableDouble squareSmoothness = new AnimatableDouble((Double)100.0, 0.0, 100.0);
    private AnimatableDouble easeHigh = new AnimatableDouble((Double)0.0, -100.0, 100.0);
    private AnimatableDouble easeLow = new AnimatableDouble((Double)0.0, -100.0, 100.0);
    private AnimatableBoolean randomizeOrder = new AnimatableBoolean(Boolean.FALSE);
    private AnimatableInteger randomSeed = new AnimatableInteger((Integer)0, 0, 10000);
    private final RenderContext context;

    @Inject
    public TARangeSelectorImpl(RenderContext context) {
        super("\u7bc4\u56f2\u30bb\u30ec\u30af\u30bf");
        this.context = context;
    }

    public AnimatableDouble getStart() {
        return this.start;
    }

    public void setStart(AnimatableDouble start) {
        start.copyConfigurationFrom(this.start);
        this.start = start;
    }

    public AnimatableDouble getEnd() {
        return this.end;
    }

    public void setEnd(AnimatableDouble end) {
        end.copyConfigurationFrom(this.end);
        this.end = end;
    }

    public AnimatableDouble getOffset() {
        return this.offset;
    }

    public void setOffset(AnimatableDouble offset) {
        offset.copyConfigurationFrom(this.offset);
        this.offset = offset;
    }

    public AbstractTASelector.AnimatableMode getMode() {
        return this.mode;
    }

    public void setMode(AbstractTASelector.AnimatableMode mode) {
        mode.copyConfigurationFrom(this.mode);
        this.mode = mode;
    }

    public AnimatableDouble getAmount() {
        return this.amount;
    }

    public void setAmount(AnimatableDouble amount) {
        amount.copyConfigurationFrom(this.amount);
        this.amount = amount;
    }

    public TARangeSelector.Shape getShape() {
        return this.shape;
    }

    public void setShape(TARangeSelector.Shape shape) {
        this.shape = shape;
    }

    public AnimatableDouble getSquareSmoothness() {
        return this.squareSmoothness;
    }

    public void setSquareSmoothness(AnimatableDouble squareSmoothness) {
        squareSmoothness.copyConfigurationFrom(this.squareSmoothness);
        this.squareSmoothness = squareSmoothness;
    }

    public AnimatableDouble getEaseHigh() {
        return this.easeHigh;
    }

    public void setEaseHigh(AnimatableDouble easeHigh) {
        easeHigh.copyConfigurationFrom(this.easeHigh);
        this.easeHigh = easeHigh;
    }

    public AnimatableDouble getEaseLow() {
        return this.easeLow;
    }

    public void setEaseLow(AnimatableDouble easeLow) {
        easeLow.copyConfigurationFrom(this.easeLow);
        this.easeLow = easeLow;
    }

    public AnimatableBoolean getRandomizeOrder() {
        return this.randomizeOrder;
    }

    public void setRandomizeOrder(AnimatableBoolean randomizeOrder) {
        randomizeOrder.copyConfigurationFrom(this.randomizeOrder);
        this.randomizeOrder = randomizeOrder;
    }

    public AnimatableInteger getRandomSeed() {
        return this.randomSeed;
    }

    public void setRandomSeed(AnimatableInteger randomSeed) {
        randomSeed.copyConfigurationFrom(this.randomSeed);
        this.randomSeed = randomSeed;
    }

    public void prepareExpression(ExpressionScope scope) {
        scope.assignTo(this.start);
        scope.assignTo(this.end);
        scope.assignTo(this.offset);
        scope.assignTo(this.mode);
        scope.assignTo(this.amount);
        scope.assignTo(this.squareSmoothness);
        scope.assignTo(this.easeHigh);
        scope.assignTo(this.easeLow);
        scope.assignTo(this.randomizeOrder);
        scope.assignTo(this.randomSeed);
    }

    public Object createExpressionElement(CoreContext context) {
        return new TARangeSelectorExpressionElement(context);
    }

    public TASelector.Evaluator createEvaluator(int[] totals, Time mediaTime) {
        double end;
        double start;
        double start0 = (Double)this.start.value(this.context) * 0.01;
        double end0 = (Double)this.end.value(this.context) * 0.01;
        double offset = (Double)this.offset.value(this.context) * 0.01;
        if (start0 < end0) {
            start = start0 + offset;
            end = end0 + offset;
        } else {
            start = end0 + offset;
            end = start0 + offset;
        }
        final TASelector.Mode mode = (TASelector.Mode)((Object)this.mode.value(this.context));
        final double amount = (Double)this.amount.value(this.context) * 0.01;
        final double squareSmoothness = this.shape == TARangeSelector.Shape.SQUARE ? (Double)this.squareSmoothness.value(this.context) * 0.01 : 0.0;
        final double easeHigh = (Double)this.easeHigh.value(this.context) * 0.01;
        final double easeLow = (Double)this.easeLow.value(this.context) * 0.01;
        Random rndOrder = (Boolean)this.randomizeOrder.value(this.context) != false ? new Random(((Integer)this.randomSeed.value(this.context)).intValue()) : null;
        return new AbstractTASelector.AbstractEvaluator(this, totals, rndOrder){

            protected double[] evaluate(double[] combine, int index0, int index1, int total) {
                if (index0 >= index1 || index0 < 0 || index1 > total) {
                    throw new IllegalArgumentException();
                }
                double t = 0.0;
                if (TARangeSelectorImpl.this.shape == TARangeSelector.Shape.SQUARE && squareSmoothness > 0.0) {
                    double p0 = (double)index0 / (double)total;
                    double p1 = (double)index1 / (double)total;
                    double p1_or_end = Math.min(p1, end);
                    t = p1 <= start || p0 >= end ? 0.0 : (p0 <= start && p1 > start ? (p1_or_end - start) / (p1 - p0) : (p1 >= end && p0 < end ? (end - p0) / (p1 - p0) : 1.0));
                    t = Math.min(Math.max((t - 0.5) / squareSmoothness + 0.5, 0.0), 1.0);
                } else {
                    double p = (double)(index0 + index1) * 0.5 / (double)total;
                    t = (p - start) / (end - start);
                    switch (TARangeSelectorImpl.this.shape) {
                        case SQUARE: {
                            t = !(t <= 0.0) && !(t >= 1.0) ? 1 : 0;
                            break;
                        }
                        case RAMP_UP: {
                            t = Math.min(Math.max(t, 0.0), 1.0);
                            break;
                        }
                        case RAMP_DOWN: {
                            t = 1.0 - Math.min(Math.max(t, 0.0), 1.0);
                            break;
                        }
                        case TRIANGLE: {
                            t = Math.max(1.0 - Math.abs(t * 2.0 - 1.0), 0.0);
                            break;
                        }
                        case ROUND: {
                            t = Math.min(Math.max(t, 0.0), 1.0);
                            t = Math.sqrt(4.0 * t * (1.0 - t));
                            break;
                        }
                        case SMOOTH: {
                            t = Math.max(1.0 - Math.abs(t * 2.0 - 1.0), 0.0);
                            t = 0.5 * (t * t * (3.0 - 2.0 * t) + t);
                            t = t * t * (3.0 - 2.0 * t);
                            break;
                        }
                        default: {
                            throw new RuntimeException("unknown Shape: " + (Object)((Object)TARangeSelectorImpl.this.shape));
                        }
                    }
                }
                t = this.ease(t) * amount;
                return this.applyMode(mode, combine, new double[]{t, t, t});
            }

            private double ease(double t) {
                if (t == 0.0 || t == 1.0) {
                    return t;
                }
                if (easeHigh > 0.0 && easeLow > 0.0) {
                    double p = easeHigh < easeLow ? 0.5 * (1.0 + (easeLow - easeHigh) / easeLow) : 0.5 * (1.0 - (easeHigh - easeLow) / easeHigh);
                    double mix = Math.max(easeHigh, easeLow);
                    if (t < p) {
                        double u = t / p;
                        return p * u * u * u * mix + t * (1.0 - mix);
                    }
                    double q = 1.0 / (1.0 - p);
                    double u = q * (t - 1.0);
                    return (u * u * u / q + 1.0) * mix + t * (1.0 - mix);
                }
                if (easeHigh < 0.0 && easeLow < 0.0) {
                    double p = easeHigh > easeLow ? 0.5 * (1.0 + (easeLow - easeHigh) / easeLow) : 0.5 * (1.0 - (easeHigh - easeLow) / easeHigh);
                    double mix = Math.abs(Math.min(easeHigh, easeLow));
                    if (t < p) {
                        double u = t / p;
                        return p * Math.cbrt(u) * mix + t * (1.0 - mix);
                    }
                    double q = 1.0 / (1.0 - p);
                    double u = q * (t - 1.0);
                    return (Math.cbrt(u) / q + 1.0) * mix + t * (1.0 - mix);
                }
                if (easeHigh <= 0.0 && easeLow >= 0.0) {
                    double eh = -easeHigh;
                    double u = t - 1.0;
                    double t2 = (Math.cbrt(u) + 1.0) * eh + t * (1.0 - eh);
                    double t3 = t * t * t * easeLow + t * (1.0 - easeLow);
                    return t2 * t3 / t;
                }
                if (easeHigh >= 0.0 && easeLow <= 0.0) {
                    double el = -easeLow;
                    double u = t - 1.0;
                    double t2 = (u * u * u + 1.0) * easeHigh + t * (1.0 - easeHigh);
                    double t3 = Math.cbrt(t) * el + t * (1.0 - el);
                    return 1.0 - (1.0 - t2) * (1.0 - t3) / (1.0 - t);
                }
                return t;
            }
        };
    }

    public class TARangeSelectorExpressionElement
    extends AbstractTASelector.TASelectorExpressionElement {
        public TARangeSelectorExpressionElement(CoreContext context) {
            super(context);
        }

        public Object getStart() {
            return this.elem(TARangeSelectorImpl.this.start);
        }

        public Object getEnd() {
            return this.elem(TARangeSelectorImpl.this.end);
        }

        public Object getOffset() {
            return this.elem(TARangeSelectorImpl.this.offset);
        }

        public Object getMode() {
            return this.elem(TARangeSelectorImpl.this.mode);
        }

        public Object getAmount() {
            return this.elem(TARangeSelectorImpl.this.amount);
        }

        public String getShape() {
            return TARangeSelectorImpl.this.shape.name();
        }

        public Object getSquareSmoothness() {
            return this.elem(TARangeSelectorImpl.this.squareSmoothness);
        }

        public Object getEaseHigh() {
            return this.elem(TARangeSelectorImpl.this.easeHigh);
        }

        public Object getEaseLow() {
            return this.elem(TARangeSelectorImpl.this.easeLow);
        }

        public Object getRandomizeOrder() {
            return this.elem(TARangeSelectorImpl.this.randomizeOrder);
        }

        public Object getRandomSeed() {
            return this.elem(TARangeSelectorImpl.this.randomSeed);
        }
    }
}

