/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal.services;

import ch.kuramo.javie.api.IShaderProgram;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.ShaderType;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.services.IAccumulationSupport;
import ch.kuramo.javie.api.services.IShaderRegistry;
import ch.kuramo.javie.api.services.IVideoRenderSupport;
import ch.kuramo.javie.core.Util;
import ch.kuramo.javie.core.services.GLGlobal;
import ch.kuramo.javie.core.services.RenderContext;
import com.google.inject.Inject;
import java.nio.FloatBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.media.opengl.GL2;
import javax.media.opengl.GLUniformData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccumulationSupportImpl
implements IAccumulationSupport {
    private final RenderContext context;
    private final IVideoRenderSupport support;
    private final IShaderProgram program;
    private final int maxTextureImageUnits;

    @Inject
    public AccumulationSupportImpl(RenderContext context, IVideoRenderSupport support, IShaderRegistry shaders, GLGlobal glGlobal) {
        this.context = context;
        this.support = support;
        this.maxTextureImageUnits = glGlobal.getMaxTextureImageUnits();
        String programName = String.valueOf(AccumulationSupportImpl.class.getName()) + ".ACCUMULATION";
        IShaderProgram program = shaders.getProgram(programName);
        if (program == null) {
            program = shaders.registerProgram(programName, ShaderType.FRAGMENT_SHADER, null, this.createAccumulationSource());
        }
        this.program = program;
    }

    public int getMaxSourcesAtATime() {
        return this.maxTextureImageUnits;
    }

    public void accumulate(List<IVideoBuffer> srcBuffers, List<Double> weights, IVideoBuffer dstBuffer) {
        int numSrc = srcBuffers.size();
        if (numSrc > this.maxTextureImageUnits) {
            this.accumulate(srcBuffers.subList(0, this.maxTextureImageUnits), weights.subList(0, this.maxTextureImageUnits), dstBuffer);
            this.accumulate(srcBuffers.subList(this.maxTextureImageUnits, numSrc), weights.subList(this.maxTextureImageUnits, numSrc), dstBuffer);
            return;
        }
        final VideoBounds bounds = dstBuffer.getBounds();
        float[] srcOffsetAndSize = new float[numSrc * 4];
        float[] weightArray = new float[numSrc];
        Set<GLUniformData> uniforms = Util.newSet();
        int i = 0;
        while (i < numSrc) {
            uniforms.add(new GLUniformData("texSrc" + i, i));
            VideoBounds b = srcBuffers.get(i).getBounds();
            srcOffsetAndSize[i * 4] = (float)(bounds.x - b.x);
            srcOffsetAndSize[i * 4 + 1] = (float)(bounds.y - b.y);
            srcOffsetAndSize[i * 4 + 2] = b.width;
            srcOffsetAndSize[i * 4 + 3] = b.height;
            weightArray[i] = weights.get(i).floatValue();
            ++i;
        }
        uniforms.add(new GLUniformData("srcOffsetAndSize[0]", 4, FloatBuffer.wrap(srcOffsetAndSize)));
        uniforms.add(new GLUniformData("weights[0]", 1, FloatBuffer.wrap(weightArray)));
        uniforms.add(new GLUniformData("numSrc", numSrc));
        Runnable operation = new Runnable(){

            public void run() {
                GL2 gl = AccumulationSupportImpl.this.context.getGL().getGL2();
                gl.glEnable(3042);
                gl.glBlendFunc(1, 1);
                gl.glBlendEquation(32774);
                AccumulationSupportImpl.this.support.ortho2D(bounds);
                AccumulationSupportImpl.this.support.quad2D(bounds, (double[][][])new double[0][][]);
            }
        };
        int pushAttribs = 24576;
        this.support.useShaderProgram(this.program, uniforms, operation, pushAttribs, dstBuffer, srcBuffers.toArray(new IVideoBuffer[srcBuffers.size()]));
    }

    public void accumulate(List<IVideoBuffer> srcBuffers, double weight, IVideoBuffer dstBuffer) {
        this.accumulate(srcBuffers, Collections.nCopies(srcBuffers.size(), weight), dstBuffer);
    }

    private String[] createAccumulationSource() {
        List<String> source = Util.newList();
        int i = 0;
        while (i < this.maxTextureImageUnits) {
            source.add(String.format("uniform sampler2D texSrc%d;", i));
            ++i;
        }
        source.add(String.format("uniform vec4 srcOffsetAndSize[%d];", this.maxTextureImageUnits));
        source.add("vec4 getSrc(int i) {");
        source.add("\tvec4 offAndSize = srcOffsetAndSize[i];");
        source.add("\tvec2 coord = (gl_FragCoord.xy + offAndSize.xy) / offAndSize.zw;");
        source.add("\treturn");
        i = 0;
        while (i < this.maxTextureImageUnits) {
            source.add(String.format("\t\t(i == %1$d) ? texture2D(texSrc%1$d, coord) :", i));
            ++i;
        }
        source.add("\t\tvec4(0.0);");
        source.add("}");
        source.addAll(Arrays.asList(String.format("uniform float weights[%d];", this.maxTextureImageUnits), "uniform int numSrc;", "", "void main(void)", "{", "\tvec4 accum = vec4(0.0);", "\tfor (int i = 0; i < numSrc; ++i) {", "\t\taccum += weights[i]*getSrc(i);", "\t}", "\tgl_FragColor = accum;", "}"));
        return source.toArray(new String[source.size()]);
    }
}

