/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal.services;

import ch.kuramo.javie.core.Util;
import ch.kuramo.javie.core.internal.services.WinShell32;
import ch.kuramo.javie.core.services.Font;
import ch.kuramo.javie.core.services.FontList;
import ftgl.FTGL;
import ftgl.FT_Face;
import ftgl.FT_Library;
import ftgl.FT_SfntName;
import ftgl.TT_Header;
import ftgl.TT_OS2;
import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FontListImpl
implements FontList {
    private static final Logger _logger = LoggerFactory.getLogger(FontListImpl.class);
    private static final List<String> FONT_FILE_EXTENSIONS = Arrays.asList("ttf", "ttc", "dfont", "otf");
    private static final FileFilter FONT_FILE_FILTER = new FileFilter(){

        public boolean accept(File pathname) {
            String name = pathname.getName();
            int lastDot = name.indexOf(46);
            if (lastDot != -1) {
                String extension = name.substring(lastDot + 1).toLowerCase();
                return FONT_FILE_EXTENSIONS.contains(extension);
            }
            return false;
        }
    };
    private static final String OS = System.getProperty("os.name").toLowerCase().replaceAll("\\s+", "");
    private static final boolean MACOSX = OS.contains("macosx");
    private static final boolean WINDOWS = OS.contains("windows");
    private static final Locale LOCALE = Locale.getDefault();
    private static final short PLATFORM_UNICODE = 0;
    private static final short PLATFORM_MACINTOSH = 1;
    private static final short PLATFORM_WINDOWS = 3;
    private static final short LANG_MAC_en = 0;
    private static final short LANG_MAC_ja = 11;
    private static final short LANG_WIN_en_US = 1033;
    private static final short LANG_WIN_ja_JP = 1041;
    private static final short FONT_FAMILY_NAME = 1;
    private static final short FONT_SUBFAMILY_NAME = 2;
    private static final short FULL_FONT_NAME = 4;
    private static final short POSTSCRIPT_NAME = 6;
    private static final short PREFERRED_FAMILY_NAME = 16;
    private static final short PREFERRED_SUBFAMILY_NAME = 17;
    private static final short WWS_FAMILY_NAME = 21;
    private static final short WWS_SUBFAMILY_NAME = 22;
    private static final String[] MACOSX_DEFAULT_FONTS = new String[]{"HiraKakuProN-W3", "HiraKakuPro-W3", "HiraKakuProN-W6", "HiraKakuPro-W6", "Osaka", "Osaka-Mono", "Helvetica", "Monaco"};
    private static final String[] WINDOWS_DEFAULT_FONTS = new String[]{"Meiryo", "Meiryo-Bold", "MS-PGothic", "MS-Gothic", "MicrosoftSansSerif"};
    private final Map<String, Font> _fontMap = Util.newMap();
    private final Map<String, List<Font>> _familyMap = Util.newMap();
    private List<String> _familyNames;
    private Font _defaultFont;

    public FontListImpl() {
        this.initialize();
    }

    /*
     * Enabled aggressive block sorting
     */
    private List<File> listFontDirectories() {
        String[] dirs;
        if (MACOSX) {
            dirs = new String[]{String.valueOf(System.getProperty("user.home")) + "/Library/Fonts", "/Library/Fonts", "/Network/Library/Fonts", "/System/Library/Fonts"};
        } else {
            if (!WINDOWS) {
                _logger.warn("font is not supported on this platform.");
                return Collections.emptyList();
            }
            char[] path = new char[260];
            int hr = WinShell32.instance.SHGetFolderPathW(null, 20, null, 0, path);
            if (hr != 0) {
                _logger.warn("no font folder found.");
                return Collections.emptyList();
            }
            int i = 0;
            i = 0;
            while (i < path.length && path[i] != '\u0000') {
                ++i;
            }
            dirs = new String[]{new String(path, 0, i)};
        }
        List<File> list = Util.newList();
        String[] stringArray = dirs;
        int n = dirs.length;
        int n2 = 0;
        while (n2 < n) {
            String dir = stringArray[n2];
            File dirFile = new File(dir);
            if (dirFile.isDirectory()) {
                list.add(dirFile);
            }
            ++n2;
        }
        return list;
    }

    private List<File> listFontFiles() {
        List<File> list = Util.newList();
        for (File dir : this.listFontDirectories()) {
            list.addAll(Arrays.asList(dir.listFiles(FONT_FILE_FILTER)));
        }
        return list;
    }

    private void initialize() {
        String[] stringArray;
        FT_Library[] ftlib = new FT_Library[1];
        long error = FTGL.ft_Init_FreeType((FT_Library[])ftlib);
        if (error != 0L) {
            _logger.error("FT_Init_FreeType: error=" + error);
            return;
        }
        try {
            for (File fontFile : this.listFontFiles()) {
                this.examineFontFile(ftlib[0], fontFile);
            }
        }
        finally {
            error = FTGL.ft_Done_FreeType((FT_Library)ftlib[0]);
            if (error != 0L) {
                _logger.error("FT_Done_FreeType: error=" + error);
            }
        }
        for (Font font : this._fontMap.values()) {
            List<Font> family = this._familyMap.get(font.familyName);
            if (family == null) {
                family = Util.newList();
                this._familyMap.put(font.familyName, family);
            }
            family.add(font);
        }
        Comparator<Font> comparator = new Comparator<Font>(){

            @Override
            public int compare(Font o1, Font o2) {
                int compare = o1.familyName.compareTo(o2.familyName);
                if (compare != 0) {
                    return compare;
                }
                compare = o1.width - o2.width;
                if (compare != 0) {
                    return compare;
                }
                compare = o1.weight - o2.weight;
                if (compare != 0) {
                    return compare;
                }
                boolean regular1 = o1.isRegular();
                boolean regular2 = o2.isRegular();
                if (regular1 && !regular2) {
                    return -1;
                }
                if (!regular1 && regular2) {
                    return 1;
                }
                compare = o1.subfamilyName.compareTo(o2.subfamilyName);
                if (compare != 0) {
                    return compare;
                }
                compare = o1.fullName.compareTo(o2.fullName);
                if (compare != 0) {
                    return compare;
                }
                return o1.psName.compareTo(o2.psName);
            }
        };
        for (Map.Entry entry : this._familyMap.entrySet()) {
            List family = (List)entry.getValue();
            Collections.sort(family, comparator);
            entry.setValue(Collections.unmodifiableList(family));
        }
        this._familyNames = Util.newList(this._familyMap.keySet());
        Collections.sort(this._familyNames);
        this._familyNames = Collections.unmodifiableList(this._familyNames);
        String[] stringArray2 = stringArray = MACOSX ? MACOSX_DEFAULT_FONTS : (WINDOWS ? WINDOWS_DEFAULT_FONTS : new String[]{});
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String psName = stringArray2[n2];
            this._defaultFont = this._fontMap.get(psName);
            if (this._defaultFont != null) break;
            ++n2;
        }
        if (this._defaultFont == null && this._familyMap.size() > 0) {
            this._defaultFont = this._familyMap.get(this._familyNames.get(0)).get(0);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void examineFontFile(FT_Library ftlib, File fontFile) {
        FT_Face[] face = new FT_Face[1];
        int i = 0;
        while (true) {
            int error;
            block8: {
                if ((error = FTGL.ft_New_Face((FT_Library)ftlib, (String)fontFile.getAbsolutePath(), (int)i, (FT_Face[])face)) != 0) {
                    if (error != 6) {
                        _logger.error(String.format("FT_New_Face: error=%d (fontFile=%s, faceIndex=%d)", error, fontFile.getAbsolutePath(), i));
                    }
                    return;
                }
                try {
                    if (this.examineFontFace(fontFile, i, face[0])) break block8;
                }
                catch (Throwable throwable) {
                    error = FTGL.ft_Done_Face((FT_Face)face[0]);
                    if (error != 0) {
                        _logger.error(String.format("FT_Done_Face: error=%d (fontFile=%s, faceIndex=%d)", error, fontFile.getAbsolutePath(), i));
                    }
                    throw throwable;
                }
                error = FTGL.ft_Done_Face((FT_Face)face[0]);
                if (error != 0) {
                    _logger.error(String.format("FT_Done_Face: error=%d (fontFile=%s, faceIndex=%d)", error, fontFile.getAbsolutePath(), i));
                }
                return;
            }
            error = FTGL.ft_Done_Face((FT_Face)face[0]);
            if (error != 0) {
                _logger.error(String.format("FT_Done_Face: error=%d (fontFile=%s, faceIndex=%d)", error, fontFile.getAbsolutePath(), i));
            }
            ++i;
        }
    }

    private boolean examineFontFace(File fontFile, int faceIndex, FT_Face face) {
        TT_OS2 os2Table = FTGL.ft_Get_Sfnt_OS2_Table((FT_Face)face);
        TT_Header ttHeader = FTGL.ft_Get_Sfnt_Header_Table((FT_Face)face);
        SfntName psName = null;
        SfntName fullName = null;
        SfntName familyName = null;
        SfntName subfamilyName = null;
        SfntName prfFamilyName = null;
        SfntName prfSubfamilyName = null;
        SfntName wwsFamilyName = null;
        SfntName wwsSubfamilyName = null;
        FT_SfntName[] sfntName = new FT_SfntName[1];
        int j = 0;
        int n = FTGL.ft_Get_Sfnt_Name_Count((FT_Face)face);
        while (j < n) {
            int error = FTGL.ft_Get_Sfnt_Name((FT_Face)face, (int)j, (FT_SfntName[])sfntName);
            if (error != 0) {
                _logger.error(String.format("FT_Get_Sfnt_Name: error=%d (fontFile=%s, faceIndex=%d)", error, fontFile.getAbsolutePath(), faceIndex));
                break;
            }
            SfntName name = new SfntName(sfntName[0]);
            switch (name.name_id) {
                case 6: {
                    psName = this.preferredName(psName, name);
                    break;
                }
                case 4: {
                    fullName = this.preferredName(fullName, name);
                    break;
                }
                case 1: {
                    familyName = this.preferredName(familyName, name);
                    break;
                }
                case 2: {
                    subfamilyName = this.preferredName(subfamilyName, name);
                    break;
                }
                case 16: {
                    prfFamilyName = this.preferredName(prfFamilyName, name);
                    break;
                }
                case 17: {
                    prfSubfamilyName = this.preferredName(prfSubfamilyName, name);
                    break;
                }
                case 21: {
                    wwsFamilyName = this.preferredName(wwsFamilyName, name);
                    break;
                }
                case 22: {
                    wwsSubfamilyName = this.preferredName(wwsSubfamilyName, name);
                }
            }
            ++j;
        }
        if (psName == null) {
            _logger.debug("no postscript name found: " + fontFile.getAbsolutePath());
            return false;
        }
        if (this._fontMap.containsKey(psName.string)) {
            _logger.debug("postscript name already exists: " + psName.string);
            return false;
        }
        if (fullName == null) {
            _logger.debug("no full name found: " + psName.string);
            fullName = psName;
        }
        if (prfFamilyName != null) {
            familyName = this.preferredName(prfFamilyName, familyName);
        }
        if (prfSubfamilyName != null) {
            subfamilyName = this.preferredName(prfSubfamilyName, subfamilyName);
        }
        if (os2Table == null || (os2Table.fsSelection & 0x100) == 0) {
            if (wwsFamilyName != null) {
                familyName = this.preferredName(wwsFamilyName, familyName);
            }
            if (wwsSubfamilyName != null) {
                subfamilyName = this.preferredName(wwsSubfamilyName, subfamilyName);
            }
        }
        if (familyName == null) {
            _logger.debug("no family name found: " + psName.string);
            familyName = fullName;
        }
        if (subfamilyName == null) {
            _logger.debug("no subfamily name found: " + psName.string);
        }
        this._fontMap.put(psName.string, new Font(psName.string, fullName.string, familyName.string, subfamilyName != null ? subfamilyName.string : "", os2Table != null ? os2Table.usWeightClass & 0xFFFF : 400, os2Table != null ? os2Table.usWidthClass & 0xFFFF : 5, os2Table != null ? os2Table.fsSelection & 0xFFFF : -1, ttHeader != null ? ttHeader.Mac_Style & 0xFFFF : -1, fontFile, faceIndex));
        return true;
    }

    private SfntName preferredName(SfntName name1, SfntName name2) {
        short preferedLangId;
        short preferedPlatId;
        if (name1 == null && name2 == null) {
            throw new IllegalArgumentException();
        }
        if (name1 == null) {
            return name2;
        }
        if (name2 == null) {
            return name1;
        }
        short s = MACOSX ? (short)1 : (preferedPlatId = WINDOWS ? (short)3 : 0);
        short s2 = MACOSX ? (LOCALE.getLanguage().equals("ja") ? (short)11 : 0) : (WINDOWS ? (LOCALE.getLanguage().equals("ja") ? (short)1041 : 1033) : (preferedLangId = -1));
        if (name1.platform_id == preferedPlatId && name2.platform_id != preferedPlatId) {
            return name1;
        }
        if (name1.platform_id != preferedPlatId && name2.platform_id == preferedPlatId) {
            return name2;
        }
        if (name1.platform_id == 0 && name2.platform_id != 0) {
            return name1;
        }
        if (name1.platform_id != 0 && name2.platform_id == 0) {
            return name2;
        }
        if (name1.language_id == preferedLangId && name2.language_id != preferedLangId) {
            return name1;
        }
        if (name1.language_id != preferedLangId && name2.language_id == preferedLangId) {
            return name2;
        }
        short s3 = MACOSX ? (short)0 : (preferedLangId = WINDOWS ? (short)1033 : -1);
        if (name1.language_id == preferedLangId && name2.language_id != preferedLangId) {
            return name1;
        }
        if (name1.language_id != preferedLangId && name2.language_id == preferedLangId) {
            return name2;
        }
        return name1;
    }

    @Override
    public List<String> listFamilyNames() {
        return this._familyNames;
    }

    @Override
    public List<Font> getFamily(String familyName) {
        return this._familyMap.get(familyName);
    }

    @Override
    public Font get(String psName) {
        return this._fontMap.get(psName);
    }

    @Override
    public Font defaultFont() {
        return this._defaultFont;
    }

    private static class SfntName {
        final short platform_id;
        final short language_id;
        final short name_id;
        final String string;

        SfntName(FT_SfntName ftSfntName) {
            this.platform_id = ftSfntName.platform_id;
            this.language_id = ftSfntName.language_id;
            this.name_id = ftSfntName.name_id;
            this.string = ftSfntName.stringAsJavaString();
        }
    }
}

