/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal.services;

import ch.kuramo.javie.core.JavieRuntimeException;
import ch.kuramo.javie.core.Util;
import ch.kuramo.javie.core.services.GLGlobal;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.ReentrantLock;
import javax.media.opengl.GL;
import javax.media.opengl.GL2;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLException;
import javax.media.opengl.GLPbuffer;
import javax.media.opengl.GLProfile;
import javax.media.opengl.Threading;
import javax.media.opengl.awt.GLCanvas;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GLGlobalImpl
implements GLGlobal {
    private final ReentrantLock _lock = new ReentrantLock();
    private final String _initError;
    private final GLPbuffer _pbuffer;
    private final GLContext _sharedContext;
    private final boolean _macosx;
    private final boolean _intel;
    private final boolean _amdAti;
    private final boolean _nvidia;
    private final String _driverVersion;
    private final int _maxSamples;
    private final int _maxTextureImageUnits;
    private final Set<String> _extensions;
    private final String _report;
    private Queue<GLContext> _pool;
    private GLCapabilitiesImmutable _canvasCapabilities;

    public GLGlobalImpl() {
        GLProfile profile = GLProfile.getMaxFixedFunc();
        GLCapabilities glcap = new GLCapabilities(profile);
        glcap.setHardwareAccelerated(true);
        glcap.setDoubleBuffered(false);
        glcap.setOnscreen(true);
        glcap.setPBuffer(false);
        this.setCanvasCapabilities((GLCapabilitiesImmutable)glcap);
        glcap.setOnscreen(false);
        glcap.setPBuffer(true);
        GLPbuffer pbuf = null;
        GLException exception = null;
        try {
            pbuf = GLDrawableFactory.getFactory((GLProfile)profile).createGLPbuffer(null, (GLCapabilitiesImmutable)glcap, null, 1, 1, null);
        }
        catch (GLException e) {
            exception = e;
        }
        Object[] strings = new String[3];
        int[] integers = new int[2];
        String[][] extensions = new String[1][];
        if (pbuf != null) {
            this._initError = null;
            this._pbuffer = pbuf;
            this._sharedContext = pbuf.getContext();
            Threading.invokeOnOpenGLThread((Runnable)new Runnable((String[])strings, integers, extensions){
                private final /* synthetic */ String[] val$strings;
                private final /* synthetic */ int[] val$integers;
                private final /* synthetic */ String[][] val$extensions;
                {
                    this.val$strings = stringArray;
                    this.val$integers = nArray;
                    this.val$extensions = stringArray2;
                }

                public void run() {
                    GLGlobalImpl.this._sharedContext.makeCurrent();
                    try {
                        GL gl = GLGlobalImpl.this._sharedContext.getGL();
                        this.val$strings[0] = gl.glGetString(7936);
                        this.val$strings[1] = gl.glGetString(7938);
                        gl.glGetIntegerv(36183, this.val$integers, 0);
                        gl.glGetIntegerv(34930, this.val$integers, 1);
                        String extStr = gl.glGetString(7939);
                        if (extStr != null) {
                            this.val$extensions[0] = extStr.split("\\s+");
                            Arrays.sort(this.val$extensions[0]);
                        } else {
                            this.val$extensions[0] = new String[0];
                        }
                        this.val$strings[this.val$strings.length - 1] = GLGlobalImpl.this.buildReport(gl, this.val$extensions[0]);
                    }
                    finally {
                        GLGlobalImpl.this._sharedContext.release();
                    }
                }
            });
        } else {
            this._initError = exception.getMessage();
            this._pbuffer = null;
            this._sharedContext = null;
            Arrays.fill(strings, "");
            Arrays.fill(integers, 0);
        }
        this._macosx = System.getProperty("os.name").replaceAll("\\s+", "").toLowerCase().contains("macosx");
        List<String> lcVendor = Arrays.asList(((String)strings[0]).toLowerCase().split("\\s+"));
        this._intel = lcVendor.contains("intel");
        this._amdAti = lcVendor.contains("amd") || lcVendor.contains("ati");
        this._nvidia = lcVendor.contains("nvidia");
        this._driverVersion = this.diverVersionFromVersionString((String)strings[1]);
        this._maxSamples = integers[0];
        this._maxTextureImageUnits = integers[1];
        this._extensions = Collections.unmodifiableSet(Util.newLinkedHashSet(Arrays.asList(extensions[0])));
        this._report = strings[strings.length - 1];
    }

    private String diverVersionFromVersionString(String version) {
        if (this._macosx) {
            int index = version.lastIndexOf(45);
            if (index != -1) {
                return version.substring(index + 1);
            }
        } else if (this._intel) {
            int index = version.lastIndexOf(32);
            if (index != -1) {
                return version.substring(index + 1);
            }
        } else if (this._amdAti) {
            int index = version.indexOf(32);
            if (index != -1) {
                version = version.substring(0, index);
            }
            if ((index = version.lastIndexOf(46)) != -1) {
                return version.substring(index + 1);
            }
        }
        return "Unknown";
    }

    private String buildReport(GL gl, String[] extensions) {
        StringBuilder sb = new StringBuilder();
        sb.append("GL_RENDERER: ").append(gl.glGetString(7937)).append("\n");
        sb.append("GL_VENDOR: ").append(gl.glGetString(7936)).append("\n");
        sb.append("GL_VERSION: ").append(gl.glGetString(7938)).append("\n");
        sb.append("GL_SHADING_LANGUAGE_VERSION: ").append(gl.glGetString(35724)).append("\n");
        sb.append("\nExtensions:\n");
        String[] stringArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            String ext = stringArray[n2];
            sb.append(ext).append("\n");
            ++n2;
        }
        sb.append("\nMax Values:\n");
        Field[] fields = GL2.class.getFields();
        Arrays.sort(fields, new Comparator<Field>(){

            @Override
            public int compare(Field f1, Field f2) {
                return f1.getName().compareTo(f2.getName());
            }
        });
        int[] integers = new int[2];
        Field[] fieldArray = fields;
        int n3 = fields.length;
        int n4 = 0;
        while (n4 < n3) {
            Field f = fieldArray[n4];
            int mod = f.getModifiers();
            if (Modifier.isStatic(mod) && Modifier.isFinal(mod) && f.getType() == Integer.TYPE && f.getName().startsWith("GL_MAX_")) {
                try {
                    gl.glGetIntegerv(((Integer)f.get(null)).intValue(), integers, 0);
                    int error = gl.glGetError();
                    if (error != 0) {
                        if (error != 1280) {
                            sb.append(String.valueOf(f.getName()) + ": ERROR=" + error).append("\n");
                        }
                    } else if (f.getName().equals("GL_MAX_VIEWPORT_DIMS")) {
                        sb.append(String.format("GL_MAX_VIEWPORT_DIMS: %d x %d%n", integers[0], integers[1]));
                    } else {
                        sb.append(String.valueOf(f.getName()) + ": " + integers[0]).append("\n");
                    }
                }
                catch (Exception e) {
                    sb.append(String.valueOf(f.getName()) + ": ERROR=" + e.getMessage()).append("\n");
                }
            }
            ++n4;
        }
        return sb.toString();
    }

    @Override
    public ReentrantLock getGlobalLock() {
        return this._lock;
    }

    @Override
    public String getInitError() {
        return this._initError;
    }

    @Override
    public GLContext getSharedContext() {
        return this._sharedContext;
    }

    @Override
    public boolean isMacOSX() {
        return this._macosx;
    }

    @Override
    public boolean isIntel() {
        return this._intel;
    }

    @Override
    public boolean isAmdAti() {
        return this._amdAti;
    }

    @Override
    public boolean isNvidia() {
        return this._nvidia;
    }

    @Override
    public String getDriverVersion() {
        return this._driverVersion;
    }

    @Override
    public int getMaxSamples() {
        return this._maxSamples;
    }

    @Override
    public int getMaxTextureImageUnits() {
        return this._maxTextureImageUnits;
    }

    @Override
    public Set<String> getExtensions() {
        return this._extensions;
    }

    @Override
    public String getReport() {
        return this._report;
    }

    @Override
    public void enterPoolMode(final int poolSize) {
        if (this._pool != null) {
            throw new IllegalStateException("already in pool mode");
        }
        if (poolSize <= 0) {
            throw new IllegalArgumentException("poolSize must be one or greater");
        }
        this._pool = new ConcurrentLinkedQueue<GLContext>();
        Threading.invokeOnOpenGLThread((Runnable)new Runnable(){

            public void run() {
                GLCapabilitiesImmutable caps = GLGlobalImpl.this._pbuffer.getChosenGLCapabilities();
                GLDrawableFactory factory = GLDrawableFactory.getFactory((GLProfile)caps.getGLProfile());
                int i = 0;
                while (i < poolSize) {
                    GLPbuffer pbuf = factory.createGLPbuffer(null, caps, null, 1, 1, GLGlobalImpl.this._sharedContext);
                    GLContext context = pbuf.getContext();
                    context.makeCurrent();
                    context.release();
                    GLGlobalImpl.this._pool.offer(context);
                    ++i;
                }
            }
        });
    }

    @Override
    public GLContext createContext() {
        if (this._pool != null) {
            GLContext context = this._pool.poll();
            if (context == null) {
                throw new JavieRuntimeException("no GLContext is available");
            }
            return context;
        }
        GLCapabilitiesImmutable caps = this._pbuffer.getChosenGLCapabilities();
        GLDrawableFactory factory = GLDrawableFactory.getFactory((GLProfile)caps.getGLProfile());
        GLPbuffer pbuf = factory.createGLPbuffer(null, caps, null, 1, 1, this._sharedContext);
        GLContext context = pbuf.getContext();
        context.putAttachedObject(String.valueOf(this.getClass().getName()) + ".pbuffer", (Object)pbuf);
        return context;
    }

    @Override
    public void destroyContext(GLContext context) {
        if (this._pool != null) {
            this._pool.offer(context);
        } else {
            GLPbuffer pbuf = (GLPbuffer)context.getAttachedObject(String.valueOf(this.getClass().getName()) + ".pbuffer");
            pbuf.destroy();
        }
    }

    @Override
    public GLCapabilitiesImmutable getCanvasCapabilities() {
        return this._canvasCapabilities;
    }

    @Override
    public void setCanvasCapabilities(GLCapabilitiesImmutable capabilities) {
        this._canvasCapabilities = (GLCapabilitiesImmutable)capabilities.cloneMutable();
    }

    @Override
    public GLCanvas createCanvas() {
        return new GLCanvas(this._canvasCapabilities, null, this._sharedContext, null);
    }
}

