/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal.services;

import ch.kuramo.javie.api.ICamera;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.services.IVideoEffectContext;
import ch.kuramo.javie.core.Util;
import ch.kuramo.javie.core.internal.services.AbstractEffectContextProxy;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VideoEffectContextProxy
extends AbstractEffectContextProxy<IVideoEffectContext>
implements IVideoEffectContext {
    private static final ThreadLocal<LinkedList<IVideoEffectContext>> _threadLocal = new ThreadLocal();

    static void push(IVideoEffectContext impl) {
        VideoEffectContextProxy.getStack(true).addLast(impl);
    }

    static void pop() {
        LinkedList<IVideoEffectContext> stack = VideoEffectContextProxy.getStack(false);
        stack.removeLast();
        if (stack.isEmpty()) {
            _threadLocal.remove();
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static LinkedList<IVideoEffectContext> getStack(boolean create) {
        void var1_3;
        LinkedList<IVideoEffectContext> linkedList = _threadLocal.get();
        if (linkedList == null) {
            if (!create) throw new IllegalStateException("no stack is found");
            LinkedList linkedList2 = Util.newLinkedList();
            _threadLocal.set(linkedList2);
            return var1_3;
        } else {
            if (!linkedList.isEmpty()) return var1_3;
            throw new IllegalStateException("stack is empty");
        }
    }

    @Override
    protected IVideoEffectContext getImpl() {
        return VideoEffectContextProxy.getStack(false).getLast();
    }

    public VideoBounds getPreviousBounds() {
        return this.getImpl().getPreviousBounds();
    }

    public IVideoBuffer doPreviousEffect() {
        return this.getImpl().doPreviousEffect();
    }

    public ICamera getCamera() {
        return this.getImpl().getCamera();
    }
}

