/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.gluegen.opengl;

import com.jogamp.gluegen.GlueEmitterControls;
import com.jogamp.gluegen.MethodBinding;
import com.jogamp.gluegen.opengl.BuildStaticGLInfo;
import com.jogamp.gluegen.opengl.GLEmitter;
import com.jogamp.gluegen.procaddress.ProcAddressConfiguration;
import com.jogamp.gluegen.runtime.opengl.GLExtensionNames;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GLConfiguration
extends ProcAddressConfiguration {
    private List<String> glHeaders = new ArrayList<String>();
    private Set<String> ignoredExtensions = new HashSet<String>();
    private Set<String> extensionsRenamedIntoCore = new HashSet<String>();
    private BuildStaticGLInfo glInfo;
    private Map<String, GLEmitter.BufferObjectKind> bufferObjectKinds = new HashMap<String, GLEmitter.BufferObjectKind>();
    private GLEmitter emitter;
    private Set<String> dropUniqVendorExtensions = new HashSet<String>();
    private boolean autoUnifyExtensions = false;
    private boolean allowNonGLExtensions = false;

    public GLConfiguration(GLEmitter gLEmitter) {
        this.emitter = gLEmitter;
        try {
            this.setProcAddressNameExpr("PFN $UPPERCASE({0}) PROC");
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new RuntimeException("Error configuring ProcAddressNameExpr", noSuchElementException);
        }
    }

    protected void dispatch(String string, StringTokenizer stringTokenizer, File file, String string2, int n) throws IOException {
        if (string.equalsIgnoreCase("IgnoreExtension")) {
            String string3 = this.readString("IgnoreExtension", stringTokenizer, string2, n);
            this.ignoredExtensions.add(string3);
        } else if (string.equalsIgnoreCase("RenameExtensionIntoCore")) {
            String string4 = this.readString("RenameExtensionIntoCore", stringTokenizer, string2, n);
            this.extensionsRenamedIntoCore.add(string4);
        } else if (string.equalsIgnoreCase("AllowNonGLExtensions")) {
            this.allowNonGLExtensions = this.readBoolean("AllowNonGLExtensions", stringTokenizer, string2, n);
        } else if (string.equalsIgnoreCase("AutoUnifyExtensions")) {
            this.autoUnifyExtensions = this.readBoolean("AutoUnifyExtensions", stringTokenizer, string2, n);
        } else if (string.equalsIgnoreCase("GLHeader")) {
            String string5 = this.readString("GLHeader", stringTokenizer, string2, n);
            this.glHeaders.add(string5);
        } else if (string.equalsIgnoreCase("BufferObjectKind")) {
            this.readBufferObjectKind(stringTokenizer, string2, n);
        } else if (string.equalsIgnoreCase("DropUniqVendorExtensions")) {
            String string6 = this.readString("DropUniqVendorExtensions", stringTokenizer, string2, n);
            this.dropUniqVendorExtensions.add(string6);
        } else {
            super.dispatch(string, stringTokenizer, file, string2, n);
        }
    }

    protected void readBufferObjectKind(StringTokenizer stringTokenizer, String string, int n) {
        try {
            String string2 = stringTokenizer.nextToken();
            GLEmitter.BufferObjectKind bufferObjectKind = null;
            String string3 = stringTokenizer.nextToken();
            if (string2.equalsIgnoreCase("UnpackPixel")) {
                bufferObjectKind = GLEmitter.BufferObjectKind.UNPACK_PIXEL;
            } else if (string2.equalsIgnoreCase("PackPixel")) {
                bufferObjectKind = GLEmitter.BufferObjectKind.PACK_PIXEL;
            } else if (string2.equalsIgnoreCase("Array")) {
                bufferObjectKind = GLEmitter.BufferObjectKind.ARRAY;
            } else if (string2.equalsIgnoreCase("Element")) {
                bufferObjectKind = GLEmitter.BufferObjectKind.ELEMENT;
            } else {
                throw new RuntimeException("Error parsing \"BufferObjectKind\" command at line " + n + " in file \"" + string + "\": illegal BufferObjectKind \"" + string2 + "\", expected one of UnpackPixel, PackPixel, Array, or Element");
            }
            this.bufferObjectKinds.put(string3, bufferObjectKind);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new RuntimeException("Error parsing \"BufferObjectKind\" command at line " + n + " in file \"" + string + "\"", noSuchElementException);
        }
    }

    public List<String> javaPrologueForMethod(MethodBinding methodBinding, boolean bl, boolean bl2) {
        ArrayList arrayList = super.javaPrologueForMethod(methodBinding, bl, bl2);
        GLEmitter.BufferObjectKind bufferObjectKind = this.getBufferObjectKind(methodBinding.getName());
        if (bufferObjectKind != null) {
            ArrayList arrayList2 = new ArrayList();
            if (arrayList != null) {
                arrayList2.addAll(arrayList);
            }
            arrayList = arrayList2;
            String string = "check";
            if (bufferObjectKind == GLEmitter.BufferObjectKind.UNPACK_PIXEL) {
                string = string + "UnpackPBO";
            } else if (bufferObjectKind == GLEmitter.BufferObjectKind.PACK_PIXEL) {
                string = string + "PackPBO";
            } else if (bufferObjectKind == GLEmitter.BufferObjectKind.ARRAY) {
                string = string + "ArrayVBO";
            } else if (bufferObjectKind == GLEmitter.BufferObjectKind.ELEMENT) {
                string = string + "ElementVBO";
            } else {
                throw new RuntimeException("Unknown BufferObjectKind " + (Object)((Object)bufferObjectKind));
            }
            string = this.emitter.isBufferObjectMethodBinding(methodBinding) ? string + "Enabled" : string + "Disabled";
            string = string + "(true);";
            arrayList.add(0, string);
            if (this.emitter.isBufferObjectMethodBinding(methodBinding)) {
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    if (string2.indexOf("Buffers.rangeCheck") < 0) continue;
                    iterator.remove();
                }
            }
        }
        return arrayList;
    }

    public void dumpIgnores() {
        System.err.println("GL Ignored extensions: ");
        for (String string : this.ignoredExtensions) {
            System.err.println("\t" + string);
        }
        super.dumpIgnores();
    }

    protected boolean shouldIgnoreExtension(String string, boolean bl) {
        if (bl && this.glInfo != null) {
            String string2;
            String string3 = this.glInfo.getExtension(string);
            if (string3 != null && this.ignoredExtensions.contains(string3)) {
                return true;
            }
            boolean bl2 = GLExtensionNames.isGLEnumeration(string);
            boolean bl3 = GLExtensionNames.isGLFunction(string);
            if ((bl3 || bl2) && GLExtensionNames.isExtensionVEN(string, bl3) && this.getDropUniqVendorExtensions(string2 = GLExtensionNames.getExtensionSuffix(string, bl3))) {
                return true;
            }
        }
        return false;
    }

    public boolean shouldIgnoreInInterface(String string) {
        return this.shouldIgnoreInInterface(string, true);
    }

    public boolean shouldIgnoreInInterface(String string, boolean bl) {
        return this.shouldIgnoreExtension(string, bl) || super.shouldIgnoreInInterface(string);
    }

    public boolean shouldIgnoreInImpl(String string) {
        return this.shouldIgnoreInImpl(string, true);
    }

    public boolean shouldIgnoreInImpl(String string, boolean bl) {
        return this.shouldIgnoreExtension(string, bl) || super.shouldIgnoreInImpl(string);
    }

    public boolean getAutoUnifyExtensions() {
        return this.autoUnifyExtensions;
    }

    public boolean getAllowNonGLExtensions() {
        return this.allowNonGLExtensions;
    }

    public boolean getDropUniqVendorExtensions(String string) {
        return this.dropUniqVendorExtensions.contains(string);
    }

    GLEmitter.BufferObjectKind getBufferObjectKind(String string) {
        return this.bufferObjectKinds.get(string);
    }

    public boolean isBufferObjectFunction(String string) {
        return this.getBufferObjectKind(string) != null;
    }

    public void parseGLHeaders(GlueEmitterControls glueEmitterControls) throws IOException {
        if (!this.glHeaders.isEmpty()) {
            this.glInfo = new BuildStaticGLInfo();
            for (String string : this.glHeaders) {
                String string2 = glueEmitterControls.findHeaderFile(string);
                if (string2 == null) {
                    throw new IOException("Unable to locate header file \"" + string + "\"");
                }
                this.glInfo.parse(string2);
            }
        }
    }

    public BuildStaticGLInfo getGLInfo() {
        return this.glInfo;
    }

    public Set<String> getExtensionsRenamedIntoCore() {
        return this.extensionsRenamedIntoCore;
    }
}

