/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.impl;

import com.jogamp.opengl.impl.Debug;
import com.jogamp.opengl.impl.GLDrawableFactoryImpl;
import com.jogamp.opengl.impl.GLDynamicLookupHelper;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.NativeSurface;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;

public abstract class GLDrawableImpl
implements GLDrawable {
    protected static final boolean DEBUG = Debug.debug("GLDrawable");
    protected GLDrawableFactory factory;
    protected NativeSurface surface;
    protected GLCapabilitiesImmutable requestedCapabilities;
    protected boolean realized;

    protected GLDrawableImpl(GLDrawableFactory gLDrawableFactory, NativeSurface nativeSurface, boolean bl) {
        this.factory = gLDrawableFactory;
        this.surface = nativeSurface;
        this.realized = bl;
        this.requestedCapabilities = (GLCapabilitiesImmutable)this.surface.getGraphicsConfiguration().getNativeGraphicsConfiguration().getRequestedCapabilities();
    }

    public abstract GLDynamicLookupHelper getGLDynamicLookupHelper();

    public GLDrawableFactoryImpl getFactoryImpl() {
        return (GLDrawableFactoryImpl)this.getFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        this.surface.getGraphicsConfiguration().getScreen().getDevice().lock();
        try {
            this.destroyImpl();
        }
        finally {
            this.surface.getGraphicsConfiguration().getScreen().getDevice().unlock();
        }
    }

    protected void destroyImpl() {
        throw new GLException("Should not call this (should only be called for offscreen GLDrawables)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void swapBuffers() throws GLException {
        GLCapabilitiesImmutable gLCapabilitiesImmutable = (GLCapabilitiesImmutable)this.surface.getGraphicsConfiguration().getNativeGraphicsConfiguration().getChosenCapabilities();
        if (gLCapabilitiesImmutable.getDoubleBuffered()) {
            if (!this.surface.surfaceSwap()) {
                int n = this.lockSurface();
                if (1 == n) {
                    return;
                }
                try {
                    AbstractGraphicsDevice abstractGraphicsDevice = this.getNativeSurface().getGraphicsConfiguration().getScreen().getDevice();
                    if (2 == n) {
                        this.updateHandle();
                    }
                    this.swapBuffersImpl();
                }
                finally {
                    this.unlockSurface();
                }
            }
        } else {
            GLContext gLContext = GLContext.getCurrent();
            if (null != gLContext && gLContext.getGLDrawable() == this) {
                gLContext.getGL().glFinish();
            }
        }
        this.surface.surfaceUpdated((Object)this, this.surface, System.currentTimeMillis());
    }

    protected abstract void swapBuffersImpl();

    public static String toHexString(long l) {
        return "0x" + Long.toHexString(l);
    }

    public GLProfile getGLProfile() {
        return this.requestedCapabilities.getGLProfile();
    }

    public GLCapabilitiesImmutable getChosenGLCapabilities() {
        return (GLCapabilitiesImmutable)this.surface.getGraphicsConfiguration().getNativeGraphicsConfiguration().getChosenCapabilities();
    }

    public GLCapabilitiesImmutable getRequestedGLCapabilities() {
        return this.requestedCapabilities;
    }

    public NativeSurface getNativeSurface() {
        return this.surface;
    }

    protected void destroyHandle() {
    }

    protected void updateHandle() {
    }

    public long getHandle() {
        return this.surface.getSurfaceHandle();
    }

    public GLDrawableFactory getFactory() {
        return this.factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void setRealized(boolean bl) {
        if (this.realized != bl) {
            if (DEBUG) {
                System.err.println("setRealized: " + this.getClass().getName() + " " + this.realized + " -> " + bl);
            }
            this.realized = bl;
            AbstractGraphicsDevice abstractGraphicsDevice = this.surface.getGraphicsConfiguration().getScreen().getDevice();
            if (bl) {
                if (1 >= this.lockSurface()) {
                    throw new GLException("GLDrawableImpl.setRealized(true): already realized, but surface not ready (lockSurface)");
                }
            } else {
                abstractGraphicsDevice.lock();
            }
            try {
                this.setRealizedImpl();
                if (bl) {
                    this.updateHandle();
                }
                this.destroyHandle();
            }
            finally {
                if (bl) {
                    this.unlockSurface();
                } else {
                    abstractGraphicsDevice.unlock();
                }
            }
        } else if (DEBUG) {
            System.err.println("setRealized: " + this.getClass().getName() + " " + this.realized + " == " + bl);
        }
    }

    protected abstract void setRealizedImpl();

    public synchronized boolean isRealized() {
        return this.realized;
    }

    public int getWidth() {
        return this.surface.getWidth();
    }

    public int getHeight() {
        return this.surface.getHeight();
    }

    public int lockSurface() throws GLException {
        return this.surface.lockSurface();
    }

    public void unlockSurface() {
        this.surface.unlockSurface();
    }

    public boolean isSurfaceLocked() {
        return this.surface.isSurfaceLocked();
    }

    public String toString() {
        return this.getClass().getName() + "[Realized " + this.isRealized() + ",\n\tFactory   " + this.getFactory() + ",\n\thandle    " + GLDrawableImpl.toHexString(this.getHandle()) + ",\n\tWindow    " + this.getNativeSurface() + "]";
    }
}

