/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.sdk.scheduler;

import java.io.IOException;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.equinox.internal.p2.ui.sdk.scheduler.AutomaticUpdateMessages;
import org.eclipse.equinox.internal.p2.ui.sdk.scheduler.AutomaticUpdateScheduler;
import org.eclipse.equinox.internal.p2.ui.sdk.scheduler.AutomaticUpdater;
import org.eclipse.equinox.internal.p2.ui.sdk.scheduler.PreferenceInitializer;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.IProvisioningEventBus;
import org.eclipse.equinox.internal.provisional.p2.engine.ProfileScope;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvUI;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;

public class AutomaticUpdatePlugin
extends AbstractUIPlugin {
    private static AutomaticUpdatePlugin plugin;
    private static BundleContext context;
    private static PackageAdmin packageAdmin;
    private static ServiceReference packageAdminRef;
    private AutomaticUpdateScheduler scheduler;
    private AutomaticUpdater updater;
    private ScopedPreferenceStore preferenceStore;
    public static final String PLUGIN_ID = "org.eclipse.equinox.p2.ui.sdk.scheduler";
    static /* synthetic */ Class class$0;

    static {
        packageAdmin = null;
        packageAdminRef = null;
    }

    public static BundleContext getContext() {
        return context;
    }

    public static Bundle getBundle(String symbolicName) {
        if (packageAdmin == null) {
            return null;
        }
        Bundle[] bundles = packageAdmin.getBundles(symbolicName, null);
        if (bundles == null) {
            return null;
        }
        int i = 0;
        while (i < bundles.length) {
            if ((bundles[i].getState() & 3) == 0) {
                return bundles[i];
            }
            ++i;
        }
        return null;
    }

    public static AutomaticUpdatePlugin getDefault() {
        return plugin;
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        plugin = this;
        context = bundleContext;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.osgi.service.packageadmin.PackageAdmin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        packageAdminRef = bundleContext.getServiceReference(clazz.getName());
        packageAdmin = (PackageAdmin)bundleContext.getService(packageAdminRef);
        this.startEarly("org.eclipse.equinox.p2.exemplarysetup");
        this.startEarly("org.eclipse.equinox.frameworkadmin.equinox");
        this.startEarly("org.eclipse.equinox.simpleconfigurator.manipulator");
        this.startEarly("org.eclipse.equinox.p2.updatechecker");
        PreferenceInitializer.migratePreferences();
    }

    private boolean startEarly(String bundleName) throws BundleException {
        Bundle bundle = AutomaticUpdatePlugin.getBundle(bundleName);
        if (bundle == null) {
            return false;
        }
        bundle.start(1);
        return true;
    }

    public void stop(BundleContext bundleContext) throws Exception {
        if (this.scheduler != null) {
            this.scheduler.shutdown();
            this.scheduler = null;
        }
        if (this.updater != null) {
            this.updater.shutdown();
            this.updater = null;
        }
        packageAdmin = null;
        packageAdminRef = null;
        plugin = null;
        super.stop(bundleContext);
        context = null;
    }

    public AutomaticUpdateScheduler getScheduler() {
        if (this.scheduler == null) {
            this.scheduler = new AutomaticUpdateScheduler();
        }
        return this.scheduler;
    }

    public AutomaticUpdater getAutomaticUpdater() {
        if (this.updater == null) {
            this.updater = new AutomaticUpdater();
        }
        return this.updater;
    }

    void setScheduler(AutomaticUpdateScheduler scheduler) {
        this.scheduler = scheduler;
    }

    public IProvisioningEventBus getProvisioningEventBus() {
        ServiceReference busReference = context.getServiceReference(IProvisioningEventBus.SERVICE_NAME);
        if (busReference == null) {
            return null;
        }
        return (IProvisioningEventBus)context.getService(busReference);
    }

    public IPreferenceStore getPreferenceStore() {
        if (this.preferenceStore == null) {
            this.preferenceStore = new ScopedPreferenceStore((IScopeContext)new ProfileScope("_SELF_"), PLUGIN_ID);
        }
        return this.preferenceStore;
    }

    public void savePreferences() {
        if (this.preferenceStore != null) {
            try {
                this.preferenceStore.save();
            }
            catch (IOException e) {
                ProvUI.handleException((Throwable)e, (String)AutomaticUpdateMessages.ErrorSavingPreferences, (int)3);
            }
        }
    }
}

