/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.touchpoint.eclipse.actions;

import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.engine.Profile;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.actions.RepositoryAction;
import org.eclipse.equinox.internal.provisional.p2.repository.RepositoryEvent;

public class RemoveRepositoryAction
extends RepositoryAction {
    public static final String ID = "removeRepository";

    public IStatus execute(Map parameters) {
        try {
            RepositoryEvent event = this.createEvent(parameters);
            Profile profile = (Profile)parameters.get("profile");
            if (profile != null) {
                this.removeRepositoryFromProfile(profile, event.getRepositoryLocation(), event.getRepositoryType());
            }
            if (this.isSelfProfile(profile)) {
                this.removeFromSelf(event);
            }
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        return Status.OK_STATUS;
    }

    public IStatus undo(Map parameters) {
        try {
            RepositoryEvent event = this.createEvent(parameters);
            Profile profile = (Profile)parameters.get("profile");
            if (profile != null) {
                this.addRepositoryToProfile(profile, event.getRepositoryLocation(), event.getRepositoryNickname(), event.getRepositoryType(), event.isRepositoryEnabled());
            }
            if (this.isSelfProfile(profile)) {
                this.addToSelf(event);
            }
            return Status.OK_STATUS;
        }
        catch (CoreException e) {
            return e.getStatus();
        }
    }

    protected String getId() {
        return ID;
    }
}

