/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.director;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnitFragment;
import org.eclipse.equinox.internal.provisional.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.internal.provisional.p2.metadata.MetadataFactory;

public class AttachmentHelper {
    private static final IInstallableUnitFragment[] NO_FRAGMENTS = new IInstallableUnitFragment[0];

    public static Collection attachFragments(Collection toAttach, Map fragmentsToIUs) {
        HashMap<IInstallableUnit, IInstallableUnitFragment> fragmentBindings = new HashMap<IInstallableUnit, IInstallableUnitFragment>();
        HashMap iusToFragment = new HashMap(fragmentsToIUs.size());
        Iterator iterator = fragmentsToIUs.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry mapping = iterator.next();
            IInstallableUnitFragment fragment = (IInstallableUnitFragment)mapping.getKey();
            List existingMatches = (List)mapping.getValue();
            Iterator iterator2 = existingMatches.iterator();
            while (iterator2.hasNext()) {
                Object host = iterator2.next();
                ArrayList<IInstallableUnitFragment> potentialFragments = (ArrayList<IInstallableUnitFragment>)iusToFragment.get(host);
                if (potentialFragments == null) {
                    potentialFragments = new ArrayList<IInstallableUnitFragment>();
                    iusToFragment.put(host, potentialFragments);
                }
                potentialFragments.add(fragment);
            }
        }
        iterator = iusToFragment.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            IInstallableUnit hostIU = (IInstallableUnit)entry.getKey();
            List potentialIUFragments = (List)entry.getValue();
            ArrayList<IInstallableUnitFragment> applicableFragments = new ArrayList<IInstallableUnitFragment>();
            Iterator iterator2 = potentialIUFragments.iterator();
            while (iterator2.hasNext()) {
                IInstallableUnitFragment dependentIU = (IInstallableUnitFragment)iterator2.next();
                if (hostIU.equals((Object)dependentIU) || !dependentIU.isFragment()) continue;
                IInstallableUnitFragment potentialFragment = dependentIU;
                IRequiredCapability[] reqsFromFragment = potentialFragment.getHost();
                boolean match = true;
                boolean requirementMatched = false;
                int l = 0;
                while (l < reqsFromFragment.length && match) {
                    requirementMatched = false;
                    if (hostIU.satisfies(reqsFromFragment[l])) {
                        requirementMatched = true;
                    }
                    if (!requirementMatched) {
                        match = false;
                        break;
                    }
                    ++l;
                }
                if (!match) continue;
                applicableFragments.add(potentialFragment);
            }
            IInstallableUnitFragment theFragment = null;
            int specificityLevel = 0;
            Iterator iterator4 = applicableFragments.iterator();
            while (iterator4.hasNext()) {
                IInstallableUnitFragment fragment = (IInstallableUnitFragment)iterator4.next();
                if (fragment.getHost().length <= specificityLevel) continue;
                theFragment = fragment;
                specificityLevel = fragment.getHost().length;
            }
            if (theFragment == null) continue;
            fragmentBindings.put(hostIU, theFragment);
        }
        HashSet<IInstallableUnit> result = new HashSet<IInstallableUnit>(toAttach.size());
        Iterator iterator2 = toAttach.iterator();
        while (iterator2.hasNext()) {
            IInstallableUnit iu = (IInstallableUnit)iterator2.next();
            if (iu == null) continue;
            if (iu.isFragment()) {
                result.add(iu);
                continue;
            }
            IInstallableUnitFragment fragment = (IInstallableUnitFragment)fragmentBindings.get(iu);
            IInstallableUnitFragment[] fragments = fragment == null ? NO_FRAGMENTS : new IInstallableUnitFragment[]{fragment};
            result.add(MetadataFactory.createResolvedInstallableUnit((IInstallableUnit)iu, (IInstallableUnitFragment[])fragments));
        }
        return result;
    }
}

