/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.internal.repository.comparator;

import java.util.ArrayList;
import org.eclipse.equinox.p2.internal.repository.comparator.CharOperation;
import org.eclipse.equinox.p2.internal.repository.comparator.Utility;

public final class Signature {
    public static final char C_BOOLEAN = 'Z';
    public static final char C_BYTE = 'B';
    public static final char C_CHAR = 'C';
    public static final char C_DOUBLE = 'D';
    public static final char C_FLOAT = 'F';
    public static final char C_INT = 'I';
    public static final char C_SEMICOLON = ';';
    public static final char C_COLON = ':';
    public static final char C_LONG = 'J';
    public static final char C_SHORT = 'S';
    public static final char C_VOID = 'V';
    public static final char C_TYPE_VARIABLE = 'T';
    public static final char C_STAR = '*';
    public static final char C_EXCEPTION_START = '^';
    public static final char C_EXTENDS = '+';
    public static final char C_SUPER = '-';
    public static final char C_DOT = '.';
    public static final char C_DOLLAR = '$';
    public static final char C_ARRAY = '[';
    public static final char C_RESOLVED = 'L';
    public static final char C_UNRESOLVED = 'Q';
    public static final char C_NAME_END = ';';
    public static final char C_PARAM_START = '(';
    public static final char C_PARAM_END = ')';
    public static final char C_GENERIC_START = '<';
    public static final char C_GENERIC_END = '>';
    public static final char C_CAPTURE = '!';
    public static final String SIG_BOOLEAN = "Z";
    public static final String SIG_BYTE = "B";
    public static final String SIG_CHAR = "C";
    public static final String SIG_DOUBLE = "D";
    public static final String SIG_FLOAT = "F";
    public static final String SIG_INT = "I";
    public static final String SIG_LONG = "J";
    public static final String SIG_SHORT = "S";
    public static final String SIG_VOID = "V";
    public static final int CLASS_TYPE_SIGNATURE = 1;
    public static final int BASE_TYPE_SIGNATURE = 2;
    public static final int TYPE_VARIABLE_SIGNATURE = 3;
    public static final int ARRAY_TYPE_SIGNATURE = 4;
    public static final int WILDCARD_TYPE_SIGNATURE = 5;
    public static final int CAPTURE_TYPE_SIGNATURE = 6;
    private static final char[] BOOLEAN = "boolean".toCharArray();
    private static final char[] BYTE = "byte".toCharArray();
    private static final char[] CHAR = "char".toCharArray();
    private static final char[] DOUBLE = "double".toCharArray();
    private static final char[] FLOAT = "float".toCharArray();
    private static final char[] INT = "int".toCharArray();
    private static final char[] LONG = "long".toCharArray();
    private static final char[] SHORT = "short".toCharArray();
    private static final char[] VOID = "void".toCharArray();
    private static final char[] CAPTURE = "capture-of".toCharArray();

    public static int getParameterCount(char[] methodSignature) throws IllegalArgumentException {
        try {
            int count = 0;
            int i = CharOperation.indexOf('(', methodSignature);
            if (i < 0) {
                throw new IllegalArgumentException();
            }
            ++i;
            while (true) {
                if (methodSignature[i] == ')') {
                    return count;
                }
                int e = Utility.scanTypeSignature(methodSignature, i);
                if (e < 0) {
                    throw new IllegalArgumentException();
                }
                i = e + 1;
                ++count;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException();
        }
    }

    public static char[][] getParameterTypes(char[] methodSignature) throws IllegalArgumentException {
        try {
            int count = Signature.getParameterCount(methodSignature);
            char[][] result = new char[count][];
            if (count == 0) {
                return result;
            }
            int i = CharOperation.indexOf('(', methodSignature);
            if (i < 0) {
                throw new IllegalArgumentException();
            }
            ++i;
            int t = 0;
            while (true) {
                if (methodSignature[i] == ')') {
                    return result;
                }
                int e = Utility.scanTypeSignature(methodSignature, i);
                if (e < 0) {
                    throw new IllegalArgumentException();
                }
                result[t] = CharOperation.subarray(methodSignature, i, e + 1);
                ++t;
                i = e + 1;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException();
        }
    }

    public static char[] getReturnType(char[] methodSignature) throws IllegalArgumentException {
        int paren = CharOperation.lastIndexOf(')', methodSignature);
        if (paren == -1) {
            throw new IllegalArgumentException();
        }
        int last = Utility.scanTypeSignature(methodSignature, paren + 1);
        return CharOperation.subarray(methodSignature, paren + 1, last + 1);
    }

    public static char[][] getTypeParameterBounds(char[] formalTypeParameterSignature) throws IllegalArgumentException {
        int p1 = CharOperation.indexOf(':', formalTypeParameterSignature);
        if (p1 < 0) {
            throw new IllegalArgumentException();
        }
        if (p1 == formalTypeParameterSignature.length - 1) {
            return CharOperation.NO_CHAR_CHAR;
        }
        int p2 = CharOperation.indexOf(':', formalTypeParameterSignature, p1 + 1);
        if (p2 < 0) {
            char[] classBound = CharOperation.subarray(formalTypeParameterSignature, p1 + 1, formalTypeParameterSignature.length);
            return new char[][]{classBound};
        }
        char[] classBound = p2 == p1 + 1 ? (char[])null : CharOperation.subarray(formalTypeParameterSignature, p1 + 1, p2);
        char[][] interfaceBounds = CharOperation.splitOn(':', formalTypeParameterSignature, p2 + 1, formalTypeParameterSignature.length);
        if (classBound == null) {
            return interfaceBounds;
        }
        int resultLength = interfaceBounds.length + 1;
        char[][] result = new char[resultLength][];
        result[0] = classBound;
        System.arraycopy(interfaceBounds, 0, result, 1, interfaceBounds.length);
        return result;
    }

    /*
     * Unable to fully structure code
     */
    public static char[][] getTypeParameters(char[] methodOrTypeSignature) throws IllegalArgumentException {
        try {
            length = methodOrTypeSignature.length;
            if (length == 0) {
                return CharOperation.NO_CHAR_CHAR;
            }
            if (methodOrTypeSignature[0] != '<') {
                return CharOperation.NO_CHAR_CHAR;
            }
            paramList = new ArrayList<char[]>(1);
            paramStart = 1;
            i = 1;
            while (i < length) {
                if (methodOrTypeSignature[i] == '>') {
                    size = paramList.size();
                    if (size == 0) {
                        throw new IllegalArgumentException();
                    }
                    result = new char[size][];
                    paramList.toArray((T[])result);
                    return result;
                }
                if ((i = CharOperation.indexOf(':', methodOrTypeSignature, i)) >= 0 && i < length) ** GOTO lbl46
                throw new IllegalArgumentException();
lbl-1000:
                // 1 sources

                {
                    switch (methodOrTypeSignature[++i]) {
                        case ':': {
                            break;
                        }
                        case '>': {
                            break;
                        }
                        case 'L': {
                            try {
                                i = Utility.scanClassTypeSignature(methodOrTypeSignature, i);
                                ++i;
                            }
                            catch (IllegalArgumentException v0) {}
                            continue block16;
                        }
                        case '[': {
                            try {
                                i = Utility.scanArrayTypeSignature(methodOrTypeSignature, i);
                                ++i;
                            }
                            catch (IllegalArgumentException v1) {}
                            continue block16;
                        }
                        case 'T': {
                            try {
                                i = Utility.scanTypeVariableSignature(methodOrTypeSignature, i);
                                ++i;
                                break;
                            }
                            catch (IllegalArgumentException v2) {}
                        }
                    }
lbl46:
                    // 10 sources

                    ** while (methodOrTypeSignature[i] == ':')
                }
lbl47:
                // 1 sources

                paramList.add(CharOperation.subarray(methodOrTypeSignature, paramStart, i));
                paramStart = i;
            }
        }
        catch (ArrayIndexOutOfBoundsException v3) {}
        throw new IllegalArgumentException();
    }

    public static char[] toCharArray(char[] signature) throws IllegalArgumentException {
        int sigLength = signature.length;
        if (sigLength == 0 || signature[0] == '(' || signature[0] == '<') {
            return Signature.toCharArray(signature, CharOperation.NO_CHAR, null, true, true);
        }
        StringBuffer buffer = new StringBuffer(signature.length + 10);
        Signature.appendTypeSignature(signature, 0, true, buffer);
        char[] result = new char[buffer.length()];
        buffer.getChars(0, buffer.length(), result, 0);
        return result;
    }

    public static char[] toCharArray(char[] methodSignature, char[] methodName, char[][] parameterNames, boolean fullyQualifyTypeNames, boolean includeReturnType, boolean isVargArgs) {
        int firstParen = CharOperation.indexOf('(', methodSignature);
        if (firstParen == -1) {
            throw new IllegalArgumentException();
        }
        StringBuffer buffer = new StringBuffer(methodSignature.length + 10);
        if (includeReturnType) {
            char[] rts = Signature.getReturnType(methodSignature);
            Signature.appendTypeSignature(rts, 0, fullyQualifyTypeNames, buffer);
            buffer.append(' ');
        }
        if (methodName != null) {
            buffer.append(methodName);
        }
        buffer.append('(');
        char[][] pts = Signature.getParameterTypes(methodSignature);
        int i = 0;
        int max = pts.length;
        while (i < max) {
            if (i == max - 1) {
                Signature.appendTypeSignature(pts[i], 0, fullyQualifyTypeNames, buffer, isVargArgs);
            } else {
                Signature.appendTypeSignature(pts[i], 0, fullyQualifyTypeNames, buffer);
            }
            if (parameterNames != null) {
                buffer.append(' ');
                buffer.append(parameterNames[i]);
            }
            if (i != pts.length - 1) {
                buffer.append(',');
                buffer.append(' ');
            }
            ++i;
        }
        buffer.append(')');
        char[] result = new char[buffer.length()];
        buffer.getChars(0, buffer.length(), result, 0);
        return result;
    }

    private static int appendTypeSignature(char[] string, int start, boolean fullyQualifyTypeNames, StringBuffer buffer) {
        return Signature.appendTypeSignature(string, start, fullyQualifyTypeNames, buffer, false);
    }

    private static int appendTypeSignature(char[] string, int start, boolean fullyQualifyTypeNames, StringBuffer buffer, boolean isVarArgs) {
        if (start >= string.length) {
            throw new IllegalArgumentException();
        }
        char c = string[start];
        if (isVarArgs) {
            switch (c) {
                case '[': {
                    return Signature.appendArrayTypeSignature(string, start, fullyQualifyTypeNames, buffer, true);
                }
            }
            throw new IllegalArgumentException();
        }
        switch (c) {
            case '[': {
                return Signature.appendArrayTypeSignature(string, start, fullyQualifyTypeNames, buffer);
            }
            case 'L': 
            case 'Q': {
                return Signature.appendClassTypeSignature(string, start, fullyQualifyTypeNames, buffer);
            }
            case 'T': {
                int e = Utility.scanTypeVariableSignature(string, start);
                buffer.append(string, start + 1, e - start - 1);
                return e;
            }
            case 'Z': {
                buffer.append(BOOLEAN);
                return start;
            }
            case 'B': {
                buffer.append(BYTE);
                return start;
            }
            case 'C': {
                buffer.append(CHAR);
                return start;
            }
            case 'D': {
                buffer.append(DOUBLE);
                return start;
            }
            case 'F': {
                buffer.append(FLOAT);
                return start;
            }
            case 'I': {
                buffer.append(INT);
                return start;
            }
            case 'J': {
                buffer.append(LONG);
                return start;
            }
            case 'S': {
                buffer.append(SHORT);
                return start;
            }
            case 'V': {
                buffer.append(VOID);
                return start;
            }
            case '!': {
                return Signature.appendCaptureTypeSignature(string, start, fullyQualifyTypeNames, buffer);
            }
            case '*': 
            case '+': 
            case '-': {
                return Signature.appendTypeArgumentSignature(string, start, fullyQualifyTypeNames, buffer);
            }
        }
        throw new IllegalArgumentException();
    }

    private static int appendArrayTypeSignature(char[] string, int start, boolean fullyQualifyTypeNames, StringBuffer buffer) {
        return Signature.appendArrayTypeSignature(string, start, fullyQualifyTypeNames, buffer, false);
    }

    private static int appendCaptureTypeSignature(char[] string, int start, boolean fullyQualifyTypeNames, StringBuffer buffer) {
        if (start >= string.length - 1) {
            throw new IllegalArgumentException();
        }
        char c = string[start];
        if (c != '!') {
            throw new IllegalArgumentException();
        }
        buffer.append(CAPTURE).append(' ');
        return Signature.appendTypeArgumentSignature(string, start + 1, fullyQualifyTypeNames, buffer);
    }

    private static int appendArrayTypeSignature(char[] string, int start, boolean fullyQualifyTypeNames, StringBuffer buffer, boolean isVarArgs) {
        int length = string.length;
        if (start >= length - 1) {
            throw new IllegalArgumentException();
        }
        char c = string[start];
        if (c != '[') {
            throw new IllegalArgumentException();
        }
        int index = start;
        c = string[++index];
        while (c == '[') {
            if (index >= length - 1) {
                throw new IllegalArgumentException();
            }
            c = string[++index];
        }
        int e = Signature.appendTypeSignature(string, index, fullyQualifyTypeNames, buffer);
        int i = 1;
        int dims = index - start;
        while (i < dims) {
            buffer.append('[').append(']');
            ++i;
        }
        if (isVarArgs) {
            buffer.append('.').append('.').append('.');
        } else {
            buffer.append('[').append(']');
        }
        return e;
    }

    private static int appendClassTypeSignature(char[] string, int start, boolean fullyQualifyTypeNames, StringBuffer buffer) {
        boolean removePackageQualifiers;
        if (start >= string.length - 2) {
            throw new IllegalArgumentException();
        }
        char c = string[start];
        if (c != 'L' && c != 'Q') {
            throw new IllegalArgumentException();
        }
        boolean resolved = c == 'L';
        boolean bl = removePackageQualifiers = !fullyQualifyTypeNames;
        if (!resolved) {
            removePackageQualifiers = false;
        }
        int p = start + 1;
        int checkpoint = buffer.length();
        int innerTypeStart = -1;
        boolean inAnonymousType = false;
        while (true) {
            if (p >= string.length) {
                throw new IllegalArgumentException();
            }
            c = string[p];
            switch (c) {
                case ';': {
                    return p;
                }
                case '<': {
                    int e = Signature.appendTypeArgumentSignatures(string, p, fullyQualifyTypeNames, buffer);
                    removePackageQualifiers = false;
                    p = e;
                    break;
                }
                case '.': {
                    if (removePackageQualifiers) {
                        buffer.setLength(checkpoint);
                        break;
                    }
                    buffer.append('.');
                    break;
                }
                case '/': {
                    if (removePackageQualifiers) {
                        buffer.setLength(checkpoint);
                        break;
                    }
                    buffer.append('/');
                    break;
                }
                case '$': {
                    innerTypeStart = buffer.length();
                    inAnonymousType = false;
                    if (!resolved) break;
                    removePackageQualifiers = false;
                    buffer.append('.');
                    break;
                }
                default: {
                    if (innerTypeStart != -1 && !inAnonymousType && Character.isDigit(c)) {
                        inAnonymousType = true;
                        buffer.setLength(innerTypeStart);
                        buffer.insert(checkpoint, "new ");
                        buffer.append("(){}");
                    }
                    if (!inAnonymousType) {
                        buffer.append(c);
                    }
                    innerTypeStart = -1;
                }
            }
            ++p;
        }
    }

    private static int appendTypeArgumentSignatures(char[] string, int start, boolean fullyQualifyTypeNames, StringBuffer buffer) {
        if (start >= string.length - 1) {
            throw new IllegalArgumentException();
        }
        char c = string[start];
        if (c != '<') {
            throw new IllegalArgumentException();
        }
        buffer.append('<');
        int p = start + 1;
        int count = 0;
        while (true) {
            if (p >= string.length) {
                throw new IllegalArgumentException();
            }
            c = string[p];
            if (c == '>') {
                buffer.append('>');
                return p;
            }
            if (count != 0) {
                buffer.append(',');
            }
            int e = Signature.appendTypeArgumentSignature(string, p, fullyQualifyTypeNames, buffer);
            ++count;
            p = e + 1;
        }
    }

    private static int appendTypeArgumentSignature(char[] string, int start, boolean fullyQualifyTypeNames, StringBuffer buffer) {
        if (start >= string.length) {
            throw new IllegalArgumentException();
        }
        char c = string[start];
        switch (c) {
            case '*': {
                buffer.append('?');
                return start;
            }
            case '+': {
                buffer.append("? extends ");
                return Signature.appendTypeSignature(string, start + 1, fullyQualifyTypeNames, buffer);
            }
            case '-': {
                buffer.append("? super ");
                return Signature.appendTypeSignature(string, start + 1, fullyQualifyTypeNames, buffer);
            }
        }
        return Signature.appendTypeSignature(string, start, fullyQualifyTypeNames, buffer);
    }

    public static char[] toCharArray(char[] methodSignature, char[] methodName, char[][] parameterNames, boolean fullyQualifyTypeNames, boolean includeReturnType) {
        return Signature.toCharArray(methodSignature, methodName, parameterNames, fullyQualifyTypeNames, includeReturnType, false);
    }
}

