/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.model;

import java.net.URI;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.metadata.repository.MetadataRepositoryManager;
import org.eclipse.equinox.internal.p2.ui.ProvUIActivator;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.model.EmptyElementExplanation;
import org.eclipse.equinox.internal.p2.ui.model.QueriedElement;
import org.eclipse.equinox.internal.p2.ui.model.RootElement;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepository;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.query.IQueryable;
import org.eclipse.equinox.internal.provisional.p2.repository.IRepository;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvUI;
import org.eclipse.equinox.internal.provisional.p2.ui.model.IRepositoryElement;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.ProvisioningUtil;
import org.eclipse.equinox.internal.provisional.p2.ui.policy.IUViewQueryContext;
import org.eclipse.equinox.internal.provisional.p2.ui.policy.Policy;
import org.osgi.framework.BundleContext;

public class MetadataRepositoryElement
extends RootElement
implements IRepositoryElement {
    URI location;
    boolean isEnabled;
    String name;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public MetadataRepositoryElement(Object parent, URI location, boolean isEnabled) {
        this(parent, null, null, location, isEnabled);
    }

    public MetadataRepositoryElement(IUViewQueryContext queryContext, Policy policy, URI location, boolean isEnabled) {
        super(null, queryContext, policy);
        this.location = location;
        this.isEnabled = isEnabled;
    }

    private MetadataRepositoryElement(Object parent, IUViewQueryContext queryContext, Policy policy, URI location, boolean isEnabled) {
        super(parent, queryContext, policy);
        this.location = location;
        this.isEnabled = isEnabled;
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepository");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) {
            return this.getQueryable();
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.equinox.internal.provisional.p2.repository.IRepository");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz2) {
            return this.getQueryable();
        }
        return super.getAdapter(adapter);
    }

    protected Object[] fetchChildren(Object o, IProgressMonitor monitor) {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)200);
        try {
            this.getMetadataRepository((IProgressMonitor)sub.newChild(100));
            return super.fetchChildren(o, (IProgressMonitor)sub.newChild(100));
        }
        catch (ProvisionException e) {
            ProvUI.reportLoadFailure(this.location, e.getStatus(), 2, this.getPolicy().getRepositoryManipulator());
            return new Object[]{new EmptyElementExplanation(this, 4, e.getLocalizedMessage(), "")};
        }
    }

    protected String getImageId(Object obj) {
        return "obj/metadata_repo_obj.gif";
    }

    protected int getDefaultQueryType() {
        return 4;
    }

    public String getLabel(Object o) {
        String n = this.getName();
        if (n != null && n.length() > 0) {
            return n;
        }
        return URIUtil.toUnencodedString((URI)this.getLocation());
    }

    public IQueryable getQueryable() {
        if (this.queryable == null) {
            return (IQueryable)this.getRepository((IProgressMonitor)new NullProgressMonitor());
        }
        return this.queryable;
    }

    public IRepository getRepository(IProgressMonitor monitor) {
        try {
            return this.getMetadataRepository(monitor);
        }
        catch (ProvisionException e) {
            ProvUI.reportLoadFailure(this.location, e.getStatus(), 2, this.getPolicy().getRepositoryManipulator());
            return null;
        }
    }

    private IMetadataRepository getMetadataRepository(IProgressMonitor monitor) throws ProvisionException {
        if (this.queryable == null) {
            this.queryable = ProvisioningUtil.loadMetadataRepository(this.location, monitor);
        }
        return (IMetadataRepository)this.queryable;
    }

    public boolean knowsQueryable() {
        return this.location != null;
    }

    public URI getLocation() {
        return this.location;
    }

    public String getName() {
        if (this.name == null) {
            try {
                this.name = ProvisioningUtil.getMetadataRepositoryProperty(this.location, "p2.nickname");
                if (this.name == null) {
                    this.name = ProvisioningUtil.getMetadataRepositoryProperty(this.location, "name");
                }
                if (this.name == null) {
                    this.name = "";
                }
            }
            catch (ProvisionException provisionException) {
                this.name = "";
            }
        }
        return this.name;
    }

    public void setNickname(String name) {
        this.name = name;
    }

    public void setLocation(URI location) {
        this.location = location;
        this.setQueryable(null);
    }

    public String getDescription() {
        String description;
        block4: {
            if (ProvUI.hasNotFoundStatusBeenReported(this.location)) {
                return ProvUIMessages.MetadataRepositoryElement_NotFound;
            }
            try {
                description = ProvisioningUtil.getMetadataRepositoryProperty(this.location, "description");
                if (description != null) break block4;
                return "";
            }
            catch (ProvisionException provisionException) {
                return "";
            }
        }
        return description;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
    }

    public boolean hasQueryable() {
        IMetadataRepositoryManager manager;
        if (this.queryable != null) {
            return true;
        }
        if (this.location == null) {
            return false;
        }
        BundleContext bundleContext = ProvUIActivator.getContext();
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((manager = (IMetadataRepositoryManager)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) == null || !(manager instanceof MetadataRepositoryManager)) {
            return false;
        }
        IMetadataRepository repo = ((MetadataRepositoryManager)manager).getRepository(this.location);
        if (repo == null) {
            return false;
        }
        this.queryable = repo;
        return true;
    }

    public Policy getPolicy() {
        Object parent = this.getParent(this);
        if (parent == null) {
            return super.getPolicy();
        }
        if (parent instanceof QueriedElement) {
            return ((QueriedElement)parent).getPolicy();
        }
        return Policy.getDefault();
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("Metadata Repository Element - ");
        result.append(URIUtil.toUnencodedString((URI)this.location));
        if (this.hasQueryable()) {
            result.append(" (loaded)");
        } else {
            result.append(" (not loaded)");
        }
        return result.toString();
    }
}

