/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app;

import ch.kuramo.javie.app.Activator;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;

public class ColorUtil {
    private static final boolean COCOA = SWT.getPlatform().equals("cocoa");

    private static ColorRegistry getRegistry() {
        return Activator.getDefault().getColorRegistry();
    }

    private static Color getSystemColor(int id) {
        return Display.getCurrent().getSystemColor(id);
    }

    public static Color tableBackground() {
        return ColorUtil.getRegistry().get("COLOR_TABLE_BACKGROUND");
    }

    public static Color tableRowLine() {
        if (COCOA) {
            return ColorUtil.getRegistry().get("COLOR_TABLE_ROW_LINE_COCOA");
        }
        throw new UnsupportedOperationException("tableRowLine is only for cocoa platform");
    }

    public static Color layerRowBackground() {
        return ColorUtil.getRegistry().get("COLOR_LAYER_ROW_BACKGROUND");
    }

    public static Color switchBorderTopLeft(boolean hilighted, boolean focused, boolean layerSwitch) {
        if (COCOA && hilighted) {
            return ColorUtil.getRegistry().get(focused ? "COLOR_SWITCH_BORDER_COCOA_BLUE_TL" : "COLOR_SWITCH_BORDER_COCOA_GRAY_TL");
        }
        if (layerSwitch) {
            return ColorUtil.getSystemColor(16);
        }
        return ColorUtil.getRegistry().get("COLOR_SWITCH_BORDER_LIGHT_GRAY_TL");
    }

    public static Color switchBorderBottomRight(boolean hilighted, boolean focused, boolean layerSwitch) {
        if (COCOA && hilighted) {
            return ColorUtil.getRegistry().get(focused ? "COLOR_SWITCH_BORDER_COCOA_BLUE_BR" : "COLOR_SWITCH_BORDER_COCOA_GRAY_BR");
        }
        if (layerSwitch) {
            return ColorUtil.getSystemColor(15);
        }
        return ColorUtil.getRegistry().get("COLOR_SWITCH_BORDER_LIGHT_GRAY_BR");
    }

    private ColorUtil() {
    }
}

