/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.actions;

import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.wizards.MediaOptionsWizard;
import ch.kuramo.javie.core.MediaItem;
import ch.kuramo.javie.core.MediaOptions;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.IWorkbenchWindow;

public class MediaOptionsDialogAction
extends Action
implements ISelectionChangedListener {
    private final IWorkbenchWindow window;
    private MediaItem mediaItem;

    public MediaOptionsDialogAction(IWorkbenchWindow window, Viewer viewer) {
        super("\u30e1\u30c7\u30a3\u30a2\u30aa\u30d7\u30b7\u30e7\u30f3...");
        this.window = window;
        this.updateState(viewer.getSelection());
        viewer.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    private void updateState(ISelection selection) {
        MediaItem mi;
        MediaOptions options;
        IStructuredSelection structuredSelection;
        this.setEnabled(false);
        this.mediaItem = null;
        Object obj = null;
        if (selection instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)selection).size() == 1) {
            obj = structuredSelection.getFirstElement();
        }
        if (obj instanceof MediaItem && (options = (mi = (MediaItem)obj).getMediaOptions()) != null && options.isAvailable()) {
            this.setEnabled(true);
            this.mediaItem = mi;
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.updateState(event.getSelection());
    }

    public void run() {
        ProjectManager pm = ProjectManager.forWorkbenchWindow(this.window);
        if (pm != null && this.mediaItem != null) {
            MediaOptionsWizard wizard = new MediaOptionsWizard(pm, this.mediaItem);
            WizardDialog dialog = new WizardDialog(this.window.getShell(), (IWizard)wizard);
            dialog.open();
        }
    }
}

