/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.player;

import ch.kuramo.javie.app.InjectorHolder;
import ch.kuramo.javie.core.JavieRuntimeException;
import ch.kuramo.javie.core.services.GLGlobal;
import com.google.inject.Inject;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.media.opengl.GL2;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.awt.GLCanvas;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;

public class GLCanvasFactory {
    private static final GLCanvasFactory factory = new GLCanvasFactory();
    private int _poolSize;
    private Queue<GLCanvasRecord> _pool;
    private Composite _holder;
    @Inject
    private GLGlobal _glGlobal;

    public static GLCanvasFactory getFactory() {
        return factory;
    }

    private GLCanvasFactory() {
        InjectorHolder.getInjector().injectMembers((Object)this);
    }

    public void enterPoolMode(int poolSize) {
        if (this._pool != null) {
            throw new IllegalStateException("already in pool mode");
        }
        if (poolSize <= 0) {
            throw new IllegalArgumentException("poolSize must be one or greater");
        }
        this._poolSize = poolSize;
        this._pool = new LinkedList<GLCanvasRecord>();
    }

    public boolean isPoolMode() {
        return this._pool != null;
    }

    public GLCanvasRecord getGLCanvas(Composite parent) {
        if (this._pool != null) {
            GLCanvasRecord record = this._pool.poll();
            if (record == null) {
                throw new JavieRuntimeException("no GLCanvas is available");
            }
            record.scrolled.setParent(parent);
            record.scrolled.setVisible(true);
            return record;
        }
        return this.newRecord(parent);
    }

    public void releaseGLCanvas(GLCanvasRecord record) {
        if (this._pool != null) {
            record.scrolled.setVisible(false);
            record.scrolled.setParent(this._holder);
            this._pool.offer(record);
        } else {
            record.scrolled.dispose();
        }
    }

    private GLCanvasRecord newRecord(Composite parent) {
        ScrolledComposite scrolled = new ScrolledComposite(parent, 768);
        scrolled.setExpandHorizontal(true);
        scrolled.setExpandVertical(true);
        scrolled.setBackground(parent.getDisplay().getSystemColor(16));
        Composite embedded = new Composite((Composite)scrolled, 0x1040000);
        scrolled.setContent((Control)embedded);
        Frame awtFrame = SWT_AWT.new_Frame((Composite)embedded);
        GridBagLayout gridBag = new GridBagLayout();
        awtFrame.setLayout(gridBag);
        awtFrame.setBackground(Color.GRAY);
        GLCanvas glCanvas = this._glGlobal.createCanvas();
        gridBag.setConstraints((Component)glCanvas, new GridBagConstraints());
        awtFrame.add((Component)glCanvas);
        return new GLCanvasRecord(scrolled, embedded, awtFrame, glCanvas);
    }

    private void initPool(Composite parent) {
        if (this._holder != null) {
            throw new IllegalStateException("pool is already initialized");
        }
        if (this._pool == null) {
            throw new IllegalStateException("not in pool mode");
        }
        this._holder = new Composite(parent, 0);
        final StackLayout layout = new StackLayout();
        this._holder.setLayout((Layout)layout);
        final Display display = this._holder.getDisplay();
        final RGB bgRGB = display.getSystemColor(16).getRGB();
        final ConcurrentLinkedQueue<ScrolledComposite> controls = new ConcurrentLinkedQueue<ScrolledComposite>();
        int i = 0;
        while (i < this._poolSize) {
            final GLCanvasRecord record = this.newRecord(this._holder);
            record.glCanvas.setPreferredSize(new Dimension(1, 1));
            record.glCanvas.addGLEventListener(new GLEventListener(){

                public void init(GLAutoDrawable drawable) {
                }

                public void dispose(GLAutoDrawable drawable) {
                }

                public void reshape(GLAutoDrawable drawable, int x, int y, int width, int height) {
                }

                public void display(GLAutoDrawable drawable) {
                    GL2 gl = drawable.getGL().getGL2();
                    gl.glPushAttrib(16384);
                    try {
                        gl.glClearColor((float)bgRGB.red / 255.0f, (float)bgRGB.green / 255.0f, (float)bgRGB.blue / 255.0f, 1.0f);
                        gl.glClear(16384);
                    }
                    finally {
                        gl.glPopAttrib();
                    }
                    record.glCanvas.removeGLEventListener((GLEventListener)this);
                    display.asyncExec(new Runnable(){

                        public void run() {
                            GLCanvasFactory.this.releaseGLCanvas(record);
                            layout.topControl = (Control)controls.poll();
                            GLCanvasFactory.this._holder.layout();
                        }
                    });
                }
            });
            controls.offer(record.scrolled);
            ++i;
        }
        display.asyncExec(new Runnable(){

            public void run() {
                layout.topControl = (Control)controls.poll();
                GLCanvasFactory.this._holder.layout();
                try {
                    ProgressMonitorDialog dialog = new ProgressMonitorDialog(GLCanvasFactory.this._holder.getShell());
                    dialog.run(true, false, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            int prev = controls.size();
                            monitor.beginTask("GLCanvas\u3092\u521d\u671f\u5316\u4e2d...", prev);
                            while (!controls.isEmpty()) {
                                int curr = controls.size();
                                monitor.worked(prev - curr);
                                prev = curr;
                                Thread.sleep(10L);
                            }
                            monitor.done();
                        }
                    });
                }
                catch (InvocationTargetException e) {
                    throw new JavieRuntimeException((Throwable)e);
                }
                catch (InterruptedException e) {
                    throw new JavieRuntimeException((Throwable)e);
                }
            }
        });
    }

    public ControlContribution createControlContribution() {
        return new ControlContribution("GLCanvasFactory"){

            protected Control createControl(Composite parent) {
                GLCanvasFactory.this.initPool(parent);
                return GLCanvasFactory.this._holder;
            }
        };
    }

    public static class GLCanvasRecord {
        public final ScrolledComposite scrolled;
        public final Composite embedded;
        public final Frame awtFrame;
        public final GLCanvas glCanvas;

        public GLCanvasRecord(ScrolledComposite scrolled, Composite embedded, Frame awtFrame, GLCanvas glCanvas) {
            this.scrolled = scrolled;
            this.embedded = embedded;
            this.awtFrame = awtFrame;
            this.glCanvas = glCanvas;
        }
    }
}

