/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.project;

import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.project.ProjectOperation;
import ch.kuramo.javie.core.Layer;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.MediaLayer;
import ch.kuramo.javie.core.Project;
import ch.kuramo.javie.core.TrackMatte;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ModifyLayerTrackMatteOperation
extends ProjectOperation {
    private final String _compId;
    private final String _layerId;
    private final TrackMatte _oldTrackMatte;
    private final TrackMatte _newTrackMatte;
    private final boolean _oldVideoEnabled;
    private final boolean _newVideoEnabled;

    public ModifyLayerTrackMatteOperation(ProjectManager projectManager, MediaLayer layer, TrackMatte newTrackMatte) {
        super(projectManager, "\u30c8\u30e9\u30c3\u30af\u30de\u30c3\u30c8\u306e\u5909\u66f4");
        LayerComposition comp = projectManager.checkLayer((Layer)layer);
        MediaLayer matteLayer = this.getTrackMatteLayer(comp, layer);
        if (matteLayer == null) {
            throw new IllegalArgumentException();
        }
        TrackMatte oldTrackMatte = layer.getTrackMatte();
        this._noEffect = newTrackMatte.equals((Object)oldTrackMatte);
        this._compId = comp.getId();
        this._layerId = layer.getId();
        this._oldTrackMatte = oldTrackMatte;
        this._newTrackMatte = newTrackMatte;
        this._oldVideoEnabled = matteLayer.isVideoEnabled();
        this._newVideoEnabled = this._oldTrackMatte == TrackMatte.NONE && !this._noEffect ? false : this._oldVideoEnabled;
    }

    private MediaLayer getTrackMatteLayer(LayerComposition comp, MediaLayer layer) {
        Layer matteLayer;
        List layers = comp.getLayers();
        int layerIndex = layers.indexOf(layer);
        if (layerIndex + 1 < layers.size() && (matteLayer = (Layer)layers.get(layerIndex + 1)) instanceof MediaLayer) {
            return (MediaLayer)matteLayer;
        }
        return null;
    }

    protected IStatus executeOrRedo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        this.modifyTrackMatte(this._newTrackMatte, this._newVideoEnabled, project, pm);
        return Status.OK_STATUS;
    }

    protected IStatus undo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        this.modifyTrackMatte(this._oldTrackMatte, this._oldVideoEnabled, project, pm);
        return Status.OK_STATUS;
    }

    private void modifyTrackMatte(TrackMatte trackMatte, boolean videoEnabled, Project project, ProjectManager pm) {
        MediaLayer layer;
        LayerComposition comp = (LayerComposition)project.getComposition(this._compId);
        MediaLayer matteLayer = this.getTrackMatteLayer(comp, layer = (MediaLayer)comp.getLayer(this._layerId));
        if (matteLayer.isVideoEnabled() != videoEnabled) {
            matteLayer.setVideoEnabled(videoEnabled);
            if (pm != null) {
                pm.fireLayerPropertyChange((Layer)matteLayer, "videoEnabled");
            }
        }
        layer.setTrackMatte(trackMatte);
        if (pm != null) {
            pm.fireLayerPropertyChange((Layer)layer, "trackMatte");
        }
    }
}

