/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.project;

import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.project.ProjectOperation;
import ch.kuramo.javie.core.Layer;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.Project;
import ch.kuramo.javie.core.TextAnimator;
import ch.kuramo.javie.core.TextLayer;
import ch.kuramo.javie.core.Util;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoveTextAnimatorsOperation
extends ProjectOperation {
    private final String _compId;
    private final List<int[]> _srcData;
    private final String _dstLayerId;
    private final int _dstIndex;

    public MoveTextAnimatorsOperation(ProjectManager pm, List<Object[]> animators, TextLayer dstLayer, int moveBefore) {
        super(pm, "\u30c6\u30ad\u30b9\u30c8\u30a2\u30cb\u30e1\u30fc\u30bf\u306e\u79fb\u52d5");
        if (animators.isEmpty()) {
            this._noEffect = true;
            this._compId = null;
            this._srcData = null;
            this._dstLayerId = null;
            this._dstIndex = 0;
            return;
        }
        LayerComposition comp = pm.checkLayer((Layer)((TextLayer)animators.get(0)[0]));
        if (pm.checkLayer((Layer)dstLayer) != comp) {
            throw new IllegalArgumentException();
        }
        this._compId = comp.getId();
        this._srcData = Util.newList();
        this._dstLayerId = dstLayer.getId();
        int dstAnimatorCount = dstLayer.getTextAnimators().size();
        int dstIndex = moveBefore < 0 || moveBefore > dstAnimatorCount ? (moveBefore = dstAnimatorCount) : moveBefore;
        List tmp1 = Util.newList();
        for (Object[] o : animators) {
            TextLayer srcLayer = (TextLayer)o[0];
            TextAnimator animator = (TextAnimator)o[1];
            int layerIndex = comp.getLayers().indexOf(srcLayer);
            if (layerIndex == -1) {
                throw new IllegalArgumentException();
            }
            int animatorIndex = srcLayer.getTextAnimators().indexOf(animator);
            if (animatorIndex == -1) {
                throw new IllegalArgumentException();
            }
            this._srcData.add(new int[]{layerIndex, animatorIndex});
            if (srcLayer == dstLayer && animatorIndex < moveBefore) {
                --dstIndex;
            }
            tmp1.add(animator);
        }
        this._dstIndex = dstIndex;
        Collections.sort(this._srcData, new Comparator<int[]>(){

            @Override
            public int compare(int[] o1, int[] o2) {
                int compare = o1[0] - o2[0];
                return compare != 0 ? compare : o2[1] - o1[1];
            }
        });
        List tmp2 = Util.newList((Collection)dstLayer.getTextAnimators());
        tmp2.removeAll(tmp1);
        tmp2.addAll(this._dstIndex, tmp1);
        this._noEffect = dstLayer.getTextAnimators().equals(tmp2);
    }

    @Override
    protected IStatus executeOrRedo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        LayerComposition comp = (LayerComposition)project.getComposition(this._compId);
        TextLayer dstLayer = (TextLayer)comp.getLayer(this._dstLayerId);
        List data1 = null;
        List data2 = null;
        if (pm != null) {
            data1 = Util.newList();
            data2 = Util.newList();
        }
        List animators = Util.newList();
        for (int[] srcData : this._srcData) {
            TextLayer srcLayer = (TextLayer)comp.getLayers().get(srcData[0]);
            animators.add(0, (TextAnimator)srcLayer.getTextAnimators().remove(srcData[1]));
            if (pm == null) continue;
            data1.add(new Object[]{srcLayer, -1});
            data2.add(new Object[]{dstLayer, this._dstIndex + data2.size()});
        }
        if (pm != null) {
            pm.fireTextAnimatorsRemove(comp, (Object[][])data1.toArray((T[])new Object[data1.size()][]));
        }
        dstLayer.getTextAnimators().addAll(this._dstIndex, animators);
        if (pm != null) {
            pm.fireTextAnimatorsAdd(comp, (Object[][])data2.toArray((T[])new Object[data2.size()][]));
        }
        return Status.OK_STATUS;
    }

    @Override
    protected IStatus undo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        LayerComposition comp = (LayerComposition)project.getComposition(this._compId);
        TextLayer dstLayer = (TextLayer)comp.getLayer(this._dstLayerId);
        List data = null;
        if (pm != null) {
            data = Util.newList();
        }
        List sublist = dstLayer.getTextAnimators().subList(this._dstIndex, this._dstIndex + this._srcData.size());
        List animators = Util.newList(sublist);
        sublist.clear();
        if (pm != null) {
            pm.fireTextAnimatorsRemove(comp, new Object[][]{{dstLayer, -1}});
        }
        ListIterator<int[]> it = this._srcData.listIterator(this._srcData.size());
        while (it.hasPrevious()) {
            int[] srcData = it.previous();
            TextLayer srcLayer = (TextLayer)comp.getLayers().get(srcData[0]);
            srcLayer.getTextAnimators().add(srcData[1], (TextAnimator)animators.remove(0));
            if (pm == null) continue;
            data.add(new Object[]{srcLayer, srcData[1]});
        }
        if (pm != null) {
            pm.fireTextAnimatorsAdd(comp, (Object[][])data.toArray((T[])new Object[data.size()][]));
        }
        return Status.OK_STATUS;
    }
}

