/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.project;

import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.app.InjectorHolder;
import ch.kuramo.javie.app.PropertyUtil;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.project.ProjectOperation;
import ch.kuramo.javie.core.AnimatableValue;
import ch.kuramo.javie.core.Effect;
import ch.kuramo.javie.core.EffectableLayer;
import ch.kuramo.javie.core.Keyframe;
import ch.kuramo.javie.core.Layer;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.MediaInput;
import ch.kuramo.javie.core.MediaLayer;
import ch.kuramo.javie.core.Project;
import ch.kuramo.javie.core.ProjectDecodeException;
import ch.kuramo.javie.core.PropertyDescriptor;
import ch.kuramo.javie.core.Util;
import ch.kuramo.javie.core.services.ProjectDecoder;
import ch.kuramo.javie.core.services.ProjectEncoder;
import com.google.inject.Inject;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeStretchLayerOperation
extends ProjectOperation {
    private final double _newRate;
    private final Object _timeToHold;
    private final String _compId;
    private final Set<LayerEntry> _layers = Util.newSet();
    private final Set<PropertyEntry> _properties = Util.newSet();
    @Inject
    private ProjectEncoder _encoder;
    @Inject
    private ProjectDecoder _decoder;

    private TimeStretchLayerOperation(ProjectManager pm, List<Layer> layers, double newRate, Object timeToHold) {
        super(pm, "\u6642\u9593\u4f38\u7e2e");
        InjectorHolder.getInjector().injectMembers((Object)this);
        if (!(timeToHold instanceof Time) && !(timeToHold instanceof Boolean)) {
            throw new IllegalArgumentException();
        }
        LayerComposition comp = pm.checkLayer(layers.iterator().next());
        this._newRate = newRate;
        this._timeToHold = timeToHold;
        this._compId = comp.getId();
        for (Layer layer : layers) {
            if (pm.checkLayer(layer) != comp) {
                throw new IllegalArgumentException();
            }
            if (layer.getRate() == newRate) continue;
            this._layers.add(new LayerEntry(layer));
            for (String property : PropertyUtil.getLayerPropertyNames(layer)) {
                AnimatableValue avalue;
                Object o = PropertyUtil.getProperty(layer, property);
                if (!(o instanceof AnimatableValue) || !(avalue = (AnimatableValue)o).hasKeyframe()) continue;
                this._properties.add(new PropertyEntry(layer.getId(), -1, property, this._encoder.encodeElement((Object)avalue)));
            }
            if (!(layer instanceof EffectableLayer)) continue;
            List effects = ((EffectableLayer)layer).getEffects();
            int i = 0;
            while (i < effects.size()) {
                Effect e = (Effect)effects.get(i);
                for (PropertyDescriptor pd : e.getEffectDescriptor().getPropertyDescriptors()) {
                    AnimatableValue avalue;
                    Object o = pd.get(e);
                    if (!(o instanceof AnimatableValue) || !(avalue = (AnimatableValue)o).hasKeyframe()) continue;
                    this._properties.add(new PropertyEntry(layer.getId(), i, pd.getName(), this._encoder.encodeElement((Object)avalue)));
                }
                ++i;
            }
        }
        this._noEffect = this._layers.isEmpty();
    }

    public TimeStretchLayerOperation(ProjectManager pm, List<Layer> layers, double newRate, Time timeToHold) {
        this(pm, layers, newRate, (Object)timeToHold);
    }

    public TimeStretchLayerOperation(ProjectManager pm, List<Layer> layers, double newRate, boolean holdInPoint) {
        this(pm, layers, newRate, (Object)holdInPoint);
    }

    @Override
    protected IStatus executeOrRedo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        this.stretchKeyframes(project, pm);
        this.stretchLayers(project, pm);
        return Status.OK_STATUS;
    }

    @Override
    protected IStatus undo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        this.restoreKeyframes(project, pm);
        this.restoreLayers(project, pm);
        return Status.OK_STATUS;
    }

    private Time timeToHold(Layer layer) {
        if (this._timeToHold instanceof Time) {
            return (Time)this._timeToHold;
        }
        if (Boolean.TRUE.equals(this._timeToHold)) {
            return layer.getInPoint();
        }
        return layer.getOutPoint();
    }

    private Time stretchTime(Time oldTime, double oldRate, Time timeToHold) {
        Time sub = oldTime.subtract(timeToHold);
        return new Time((long)((double)sub.timeValue * oldRate / this._newRate), sub.timeScale).add(timeToHold);
    }

    private void stretchKeyframes(Project project, ProjectManager pm) {
        LayerComposition comp = (LayerComposition)project.getComposition(this._compId);
        List data = pm != null ? Util.newList() : null;
        for (PropertyEntry e : this._properties) {
            AnimatableValue avalue;
            Layer layer = comp.getLayer(e.layerId);
            if (e.effectIndex == -1) {
                avalue = (AnimatableValue)PropertyUtil.getProperty(layer, e.property);
            } else {
                Effect effect = (Effect)((EffectableLayer)layer).getEffects().get(e.effectIndex);
                avalue = (AnimatableValue)PropertyUtil.getProperty(effect, e.property);
            }
            double oldRate = layer.getRate();
            Time timeToHold = this.timeToHold(layer);
            List keyframes = Util.newList(avalue.getKeyframeMap().values());
            avalue.clearKeyframes(avalue.getStaticValue());
            for (Keyframe kf : keyframes) {
                Time time = this.stretchTime(kf.time, oldRate, timeToHold);
                avalue.putKeyframe(time, kf.value, kf.interpolation);
            }
            if (pm == null) continue;
            Object[] objectArray = new Object[4];
            objectArray[0] = layer;
            objectArray[1] = e.effectIndex;
            objectArray[2] = e.property;
            data.add(objectArray);
        }
        if (pm != null) {
            pm.fireKeyframesChange(comp, (Object[][])data.toArray((T[])new Object[data.size()][]));
        }
    }

    private void restoreKeyframes(Project project, ProjectManager pm) throws ExecutionException {
        LayerComposition comp = (LayerComposition)project.getComposition(this._compId);
        List data = pm != null ? Util.newList() : null;
        for (PropertyEntry e : this._properties) {
            AnimatableValue avalue;
            Layer layer = comp.getLayer(e.layerId);
            if (e.effectIndex == -1) {
                avalue = (AnimatableValue)PropertyUtil.getProperty(layer, e.property);
            } else {
                Effect effect = (Effect)((EffectableLayer)layer).getEffects().get(e.effectIndex);
                avalue = (AnimatableValue)PropertyUtil.getProperty(effect, e.property);
            }
            this.restore(e.data, avalue);
            if (pm == null) continue;
            Object[] objectArray = new Object[4];
            objectArray[0] = layer;
            objectArray[1] = e.effectIndex;
            objectArray[2] = e.property;
            data.add(objectArray);
        }
        if (pm != null) {
            pm.fireKeyframesChange(comp, (Object[][])data.toArray((T[])new Object[data.size()][]));
        }
    }

    private <A extends AnimatableValue<V>, V> void restore(String data, A dst) throws ExecutionException {
        try {
            AnimatableValue src = (AnimatableValue)this._decoder.decodeElement((CharSequence)data, dst.getClass());
            dst.reset(src.getStaticValue());
            dst.setExpression(src.getExpression());
            for (Keyframe kf : src.getKeyframeMap().values()) {
                dst.putKeyframe(kf);
            }
        }
        catch (ProjectDecodeException e) {
            throw new ExecutionException("error decoding AnimatableValue data", (Throwable)e);
        }
    }

    private void stretchLayers(Project project, ProjectManager pm) {
        LayerComposition comp = (LayerComposition)project.getComposition(this._compId);
        Set layers = Util.newSet();
        for (LayerEntry e : this._layers) {
            Time newStartTime;
            Time newOutPoint;
            Time newInPoint;
            Layer layer = comp.getLayer(e.layerId);
            double oldRate = layer.getRate();
            Time timeToHold = this.timeToHold(layer);
            if (oldRate * this._newRate > 0.0) {
                newInPoint = this.stretchTime(layer.getInPoint(), oldRate, timeToHold);
                newOutPoint = this.stretchTime(layer.getOutPoint(), oldRate, timeToHold);
                newStartTime = this.stretchTime(layer.getStartTime(), oldRate, timeToHold);
            } else {
                MediaInput mi;
                Time duration;
                newInPoint = this.stretchTime(layer.getOutPoint(), oldRate, timeToHold);
                newOutPoint = this.stretchTime(layer.getInPoint(), oldRate, timeToHold);
                newStartTime = null;
                if (layer instanceof MediaLayer && (duration = (mi = ((MediaLayer)layer).getMediaInput()).getDuration()) != null) {
                    Time endTime = layer.getStartTime().add(new Time((long)((double)duration.timeValue / Math.abs(oldRate)), duration.timeScale));
                    newStartTime = this.stretchTime(endTime, oldRate, timeToHold);
                }
                if (newStartTime == null) {
                    newStartTime = this.stretchTime(layer.getStartTime(), oldRate, timeToHold);
                }
            }
            layer.setStartTime(newStartTime);
            layer.setInPoint(newInPoint);
            layer.setOutPoint(newOutPoint);
            layer.setRate(this._newRate);
            layers.add(layer);
        }
        if (pm != null) {
            pm.fireLayerTimesChange(comp, layers);
        }
    }

    private void restoreLayers(Project project, ProjectManager pm) {
        LayerComposition comp = (LayerComposition)project.getComposition(this._compId);
        Set layers = Util.newSet();
        for (LayerEntry e : this._layers) {
            Layer layer = comp.getLayer(e.layerId);
            layer.setStartTime(e.startTime);
            layer.setInPoint(e.inPoint);
            layer.setOutPoint(e.outPoint);
            layer.setRate(e.rate);
            layers.add(layer);
        }
        if (pm != null) {
            pm.fireLayerTimesChange(comp, layers);
        }
    }

    private static class LayerEntry {
        private final String layerId;
        private final Time startTime;
        private final Time inPoint;
        private final Time outPoint;
        private final double rate;

        private LayerEntry(Layer layer) {
            this.layerId = layer.getId();
            this.startTime = layer.getStartTime();
            this.inPoint = layer.getInPoint();
            this.outPoint = layer.getOutPoint();
            this.rate = layer.getRate();
        }
    }

    private static class PropertyEntry {
        private final String layerId;
        private final int effectIndex;
        private final String property;
        private final String data;

        public PropertyEntry(String layerId, int effectIndex, String property, String data) {
            this.layerId = layerId;
            this.effectIndex = effectIndex;
            this.property = property;
            this.data = data;
        }
    }
}

