/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.views.layercomp;

import ch.kuramo.javie.app.views.layercomp.AnimatableValueElement;
import ch.kuramo.javie.app.views.layercomp.AnimatableValueElementDelegate;
import ch.kuramo.javie.core.AnimatableDouble;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnimatableDoubleElementDelegate
extends AnimatableValueElementDelegate<Double> {
    protected final double increment;
    protected final int displayPrecision;
    protected final int editorPrecision;
    protected final String unit;
    protected DoubleCellEditor editor;

    public AnimatableDoubleElementDelegate(AnimatableValueElement element, String name, AnimatableDouble avalue) {
        this(element, name, avalue, null);
    }

    public AnimatableDoubleElementDelegate(AnimatableValueElement element, String name, AnimatableDouble avalue, String unit) {
        this(element, name, avalue, 1.0, 1, 4, unit);
    }

    public AnimatableDoubleElementDelegate(AnimatableValueElement element, String name, AnimatableDouble avalue, double increment, int displayPrecision, int editorPrecision, String unit) {
        super(element, name, avalue);
        this.increment = increment;
        this.displayPrecision = displayPrecision;
        this.editorPrecision = editorPrecision;
        this.unit = unit;
    }

    @Override
    protected void drawValue(GC gc, int x, int y, int height, boolean focused) {
        if (this.editor == null) {
            this.drawValue(gc, x, y, height, focused, (Double)this.value, this.displayPrecision, this.unit);
        }
    }

    @Override
    protected boolean canDragGestureEdit() {
        return true;
    }

    @Override
    protected Double dragGesture(double dx, double dy) {
        return (Double)this.originalValue + this.increment * dx;
    }

    @Override
    public boolean canEdit(int columnIndex) {
        if (columnIndex == 1) {
            return this.canInPlaceEdit;
        }
        return false;
    }

    @Override
    public CellEditor getCellEditor(int columnIndex) {
        if (columnIndex == 1) {
            if (this.editor == null) {
                this.editor = new DoubleCellEditor((Composite)this.element.viewer.getTree(), 2052);
            }
            return this.editor;
        }
        return null;
    }

    @Override
    public Object getCellEditorValue(int columnIndex) {
        if (columnIndex == 1) {
            return this.formatValue((Double)this.value, this.editorPrecision);
        }
        return null;
    }

    @Override
    public void setCellEditorValue(int columnIndex, Object value) {
        if (columnIndex == 1 && !value.equals(this.formatValue((Double)this.value, this.editorPrecision))) {
            try {
                this.modifyValue(Double.valueOf((String)value));
            }
            catch (NumberFormatException numberFormatException) {
                this.element.viewer.getTree().getDisplay().beep();
            }
        }
    }

    private class DoubleCellEditor
    extends TextCellEditor {
        private boolean activated;

        private DoubleCellEditor(Composite parent, int style) {
            super(parent, style);
        }

        protected Control createControl(final Composite parent) {
            final Composite composite = new Composite(parent, 0x80000 | (COCOA ? 262144 : 0));
            composite.setFont(parent.getFont());
            composite.setBackground(parent.getBackground());
            composite.setLayout((Layout)new FormLayout());
            super.createControl(composite);
            this.text.setBackground(this.text.getDisplay().getSystemColor(1));
            int right = 0;
            if (AnimatableDoubleElementDelegate.this.unit != null) {
                GC gc = new GC((Drawable)composite);
                right = gc.textExtent((String)AnimatableDoubleElementDelegate.this.unit, (int)1).x + 10;
                gc.dispose();
            }
            FormData data = new FormData();
            data.top = new FormAttachment(0, 0);
            data.bottom = new FormAttachment(100, 0);
            data.left = new FormAttachment(0, WIN32 ? 3 : 0);
            data.right = new FormAttachment(100, -right);
            this.text.setLayoutData((Object)data);
            composite.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    parent.forceFocus();
                }
            });
            if (AnimatableDoubleElementDelegate.this.unit != null) {
                composite.addPaintListener(new PaintListener(){

                    public void paintControl(PaintEvent e) {
                        Rectangle bounds = DoubleCellEditor.this.text.getBounds();
                        int height = composite.getBounds().height;
                        AnimatableDoubleElementDelegate.this.setValueForeground(e.gc, false);
                        AnimatableDoubleElementDelegate.this.drawString(e.gc, bounds.width + 5, 0, height, ((DoubleCellEditor)DoubleCellEditor.this).AnimatableDoubleElementDelegate.this.unit);
                    }
                });
            }
            return composite;
        }

        public void activate() {
            super.activate();
            this.activated = true;
        }

        public void deactivate() {
            super.deactivate();
            if (this.activated) {
                AnimatableDoubleElementDelegate.this.editor = null;
                this.dispose();
            }
        }
    }
}

