/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.views.layercomp;

import ch.kuramo.javie.app.Activator;
import ch.kuramo.javie.app.EnumLabels;
import ch.kuramo.javie.app.PropertyUtil;
import ch.kuramo.javie.app.project.AddRemoveTAPropertiesOperation;
import ch.kuramo.javie.app.project.AddTASelectorOperation;
import ch.kuramo.javie.app.project.ModifyLayerPropertyOperation;
import ch.kuramo.javie.app.project.PerCharacter3DOperation;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.project.RenameTextAnimatorOperation;
import ch.kuramo.javie.app.views.layercomp.AngleElementDelegate;
import ch.kuramo.javie.app.views.layercomp.AnimatableValueElement;
import ch.kuramo.javie.app.views.layercomp.AnimatableValueElementDelegate;
import ch.kuramo.javie.app.views.layercomp.AnimatableVec3dElementDelegate;
import ch.kuramo.javie.app.views.layercomp.Element;
import ch.kuramo.javie.app.views.layercomp.LayerAnimatableValueElement;
import ch.kuramo.javie.app.views.layercomp.ScaleElementDelegate;
import ch.kuramo.javie.app.views.layercomp.Switch;
import ch.kuramo.javie.app.views.layercomp.SwitchGroup;
import ch.kuramo.javie.app.views.layercomp.TARangeSelectorElement;
import ch.kuramo.javie.app.views.layercomp.TAWigglySelectorElement;
import ch.kuramo.javie.app.views.layercomp.TextAnimatorsElement;
import ch.kuramo.javie.app.views.layercomp.Tiny2DManipVec3dElementDelegate;
import ch.kuramo.javie.app.views.layercomp.XYLinkableVec2dElementDelegate;
import ch.kuramo.javie.app.widgets.WSWin32;
import ch.kuramo.javie.core.AnimatableDouble;
import ch.kuramo.javie.core.AnimatableVec2d;
import ch.kuramo.javie.core.AnimatableVec3d;
import ch.kuramo.javie.core.Layer;
import ch.kuramo.javie.core.LayerNature;
import ch.kuramo.javie.core.TAProperty;
import ch.kuramo.javie.core.TARangeSelector;
import ch.kuramo.javie.core.TASelector;
import ch.kuramo.javie.core.TAWigglySelector;
import ch.kuramo.javie.core.TextAnimator;
import ch.kuramo.javie.core.TextLayer;
import ch.kuramo.javie.core.Util;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.TreeItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextAnimatorElement
extends Element {
    private static final int[] UNDERLINE_DASH = new int[]{2, 2};
    private static final boolean COCOA = SWT.getPlatform().equals("cocoa");
    private static final boolean WIN32 = SWT.getPlatform().equals("win32");
    public final TextAnimator animator;
    private final List<Element> children = Util.newList();
    private final Map<Object, Element> childrenMap = Util.newMap();
    private boolean perCharacter3D;
    private final SwitchGroup enableSwitch = new SwitchGroup();
    private Rectangle valueArea;
    private TextCellEditor nameEditor;
    private static final ImageRegistry imageRegistry = Activator.getDefault().getImageRegistry();

    public TextAnimatorElement(TextAnimatorsElement parent, TextAnimator animator) {
        super(parent);
        this.animator = animator;
        this.enableSwitch.add(new EnableSwitch());
        if (WSWin32.isXPThemed()) {
            this.enableSwitch.setMarginLeft(11);
        }
    }

    @Override
    public String getColumnText(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.animator.getName();
            }
        }
        return null;
    }

    @Override
    public boolean hasChildren() {
        return !this.animator.getSelectors().isEmpty() || !this.animator.getProperties().isEmpty();
    }

    @Override
    public Element[] getChildren() {
        this.prepareChildren();
        return this.children.toArray(new Element[this.children.size()]);
    }

    @Override
    public void paintColumn(Event event) {
        switch (event.index) {
            case 1: {
                String valueStr = ">";
                GC gc = event.gc;
                int x = event.x + 5;
                int y = event.y;
                int height = ((TreeItem)event.item).getBounds((int)event.index).height;
                boolean focused = (event.detail & 2) != 0 && ((Control)event.widget).isFocusControl();
                gc.setForeground(gc.getDevice().getSystemColor(focused ? 1 : 10));
                Point extent = gc.textExtent(valueStr, 1);
                gc.drawString(valueStr, x, y += (height - extent.y) / 2, true);
                this.valueArea = new Rectangle(x, y, extent.x, extent.y);
                y += extent.y;
                gc.setLineDash(UNDERLINE_DASH);
                if (COCOA) {
                    gc.drawLine(x, y - 1, x + extent.x, y - 1);
                    break;
                }
                if (WIN32) {
                    gc.drawLine(x, y, x + extent.x - 2, y);
                    break;
                }
                gc.drawLine(x, y, x + extent.x, y);
                break;
            }
            case 5: {
                this.enableSwitch.paint(event);
                break;
            }
            default: {
                super.paintColumn(event);
            }
        }
    }

    @Override
    public void updateCursor(MouseEvent event, int columnIndex) {
        switch (columnIndex) {
            case 1: {
                Cursor cursor = null;
                if (this.valueArea != null && this.valueArea.contains(event.x, event.y)) {
                    cursor = event.display.getSystemCursor(21);
                }
                this.viewer.getTree().setCursor(cursor);
                break;
            }
            default: {
                super.updateCursor(event, columnIndex);
            }
        }
    }

    @Override
    public void mouseDown(MouseEvent event, int columnIndex) {
        switch (columnIndex) {
            case 1: {
                if (event.button != 1 || this.valueArea == null || !this.valueArea.contains(event.x, event.y)) break;
                this.showMenu();
                break;
            }
            case 5: {
                this.enableSwitch.mouseDown(event);
                break;
            }
            default: {
                super.mouseDown(event, columnIndex);
            }
        }
    }

    private void showMenu() {
        Menu menu = this.createPopUpMenu(this.valueArea.x - 5, this.valueArea.y);
        MenuItem propItem = new MenuItem(menu, 64);
        Menu propMenu = new Menu(propItem);
        propItem.setMenu(propMenu);
        propItem.setText("\u30d7\u30ed\u30d1\u30c6\u30a3");
        MenuItem selectorItem = new MenuItem(menu, 64);
        Menu selectorMenu = new Menu(selectorItem);
        selectorItem.setMenu(selectorMenu);
        selectorItem.setText("\u30bb\u30ec\u30af\u30bf");
        final TextLayer layer = this.getLayer();
        boolean perCharacter3D = LayerNature.isThreeD((Layer)layer) && layer.isPerCharacter3D();
        Action action = new Action("\u6587\u5b57\u5358\u4f4d\u306e3D\u5316", 2){

            public void run() {
                ProjectManager pm = (ProjectManager)TextAnimatorElement.this.viewer.getData("PROJECT_MANAGER");
                pm.postOperation(PerCharacter3DOperation.toggle(pm, layer));
            }
        };
        action.setChecked(perCharacter3D);
        ActionContributionItem item = new ActionContributionItem((IAction)action);
        item.fill(propMenu, -1);
        new MenuItem(propMenu, 2);
        Map propActions = Util.newMap();
        TAProperty[] tAPropertyArray = TAProperty.values();
        int n = tAPropertyArray.length;
        int n2 = 0;
        while (n2 < n) {
            block8: {
                TAProperty p = tAPropertyArray[n2];
                final List data = Util.newList();
                switch (p) {
                    case skewAxis: 
                    case rotationX: 
                    case rotationY: 
                    case characterRange: {
                        break block8;
                    }
                    case rotationZ: {
                        if (perCharacter3D) {
                            data.add(new Object[]{layer, this.animator, TAProperty.rotationX});
                            data.add(new Object[]{layer, this.animator, TAProperty.rotationY});
                        }
                        data.add(new Object[]{layer, this.animator, TAProperty.rotationZ});
                        break;
                    }
                    case skew: {
                        data.add(new Object[]{layer, this.animator, TAProperty.skew});
                        data.add(new Object[]{layer, this.animator, TAProperty.skewAxis});
                        break;
                    }
                    case characterValue: 
                    case characterOffset: {
                        data.add(new Object[]{layer, this.animator, TAProperty.characterRange});
                        data.add(new Object[]{layer, this.animator, p});
                        break;
                    }
                    default: {
                        data.add(new Object[]{layer, this.animator, p});
                    }
                }
                action = new Action(EnumLabels.getLabel(p)){

                    public void run() {
                        ProjectManager pm = (ProjectManager)TextAnimatorElement.this.viewer.getData("PROJECT_MANAGER");
                        pm.postOperation(new AddRemoveTAPropertiesOperation(pm, data, true));
                    }
                };
                propActions.put(p, action);
            }
            ++n2;
        }
        TextAnimatorElement.createPropertyMenuItems(propMenu, propActions);
        action = new Action("\u7bc4\u56f2"){

            public void run() {
                ProjectManager pm = (ProjectManager)TextAnimatorElement.this.viewer.getData("PROJECT_MANAGER");
                pm.postOperation(new AddTASelectorOperation(pm, layer, TextAnimatorElement.this.animator, TARangeSelector.class));
            }
        };
        item = new ActionContributionItem((IAction)action);
        item.fill(selectorMenu, -1);
        action = new Action("\u30a6\u30a3\u30b0\u30ea\u30fc"){

            public void run() {
                ProjectManager pm = (ProjectManager)TextAnimatorElement.this.viewer.getData("PROJECT_MANAGER");
                pm.postOperation(new AddTASelectorOperation(pm, layer, TextAnimatorElement.this.animator, TAWigglySelector.class));
            }
        };
        item = new ActionContributionItem((IAction)action);
        item.fill(selectorMenu, -1);
        menu.setVisible(true);
    }

    static void createPropertyMenuItems(Menu propMenu, Map<TAProperty, Action> actions) {
        Menu fillColorMenu = null;
        Menu strokeColorMenu = null;
        TAProperty[] tAPropertyArray = TAProperty.values();
        int n = tAPropertyArray.length;
        int n2 = 0;
        while (n2 < n) {
            TAProperty p = tAPropertyArray[n2];
            Action action = actions.get(p);
            if (action != null) {
                Menu parentMenu = propMenu;
                switch (p) {
                    case rotationZ: {
                        action.setText("\u56de\u8ee2");
                        break;
                    }
                    case fillRGB: {
                        new MenuItem(propMenu, 2);
                        MenuItem fillColorItem = new MenuItem(propMenu, 64);
                        fillColorMenu = new Menu(fillColorItem);
                        fillColorItem.setMenu(fillColorMenu);
                        fillColorItem.setText("\u5857\u308a\u306e\u30ab\u30e9\u30fc");
                        parentMenu = fillColorMenu;
                        action.setText("RGB");
                        break;
                    }
                    case fillHue: 
                    case fillSaturation: 
                    case fillLuminosity: 
                    case fillOpacity: {
                        action.setText(action.getText().replaceFirst("\u5857\u308a\u306e", ""));
                        parentMenu = fillColorMenu;
                        break;
                    }
                    case strokeRGB: {
                        MenuItem strokeColorItem = new MenuItem(propMenu, 64);
                        strokeColorMenu = new Menu(strokeColorItem);
                        strokeColorItem.setMenu(strokeColorMenu);
                        strokeColorItem.setText("\u7dda\u306e\u30ab\u30e9\u30fc");
                        parentMenu = strokeColorMenu;
                        action.setText("RGB");
                        break;
                    }
                    case strokeHue: 
                    case strokeSaturation: 
                    case strokeLuminosity: 
                    case strokeOpacity: {
                        parentMenu = strokeColorMenu;
                        action.setText(action.getText().replaceFirst("\u7dda\u306e", ""));
                        break;
                    }
                    case tracking: 
                    case characterValue: 
                    case blur: {
                        new MenuItem(propMenu, 2);
                    }
                }
                ActionContributionItem item = new ActionContributionItem((IAction)action);
                item.fill(parentMenu, -1);
            }
            ++n2;
        }
    }

    @Override
    public boolean canEdit(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return Boolean.TRUE.equals(this.viewer.getData("EDIT_ELEMENT_NAME"));
            }
        }
        return false;
    }

    @Override
    public CellEditor getCellEditor(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                if (this.nameEditor == null) {
                    this.nameEditor = new TextCellEditor((Composite)this.viewer.getTree(), 2052);
                    Control control = this.nameEditor.getControl();
                    control.setBackground(control.getDisplay().getSystemColor(1));
                }
                return this.nameEditor;
            }
        }
        return null;
    }

    @Override
    public Object getCellEditorValue(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.animator.getName();
            }
        }
        return null;
    }

    @Override
    public void setCellEditorValue(int columnIndex, Object value) {
        ProjectManager pm = (ProjectManager)this.viewer.getData("PROJECT_MANAGER");
        switch (columnIndex) {
            case 0: {
                String newName = (String)value;
                if (newName.length() <= 0) break;
                pm.postOperation(new RenameTextAnimatorOperation(pm, this.getLayer(), this.animator, newName));
            }
        }
    }

    TextLayer getLayer() {
        return ((TextAnimatorsElement)this.parent).getLayer();
    }

    private Element getSelectorElement(TASelector selector) {
        Element element = this.childrenMap.get(selector);
        if (element == null) {
            if (selector instanceof TARangeSelector) {
                element = new TARangeSelectorElement(this, (TARangeSelector)selector);
            } else if (selector instanceof TAWigglySelector) {
                element = new TAWigglySelectorElement(this, (TAWigglySelector)selector);
            } else {
                throw new RuntimeException("unknown TASelector: " + selector.getClass().getName());
            }
            this.childrenMap.put(selector, element);
        }
        return element;
    }

    private Element getPropertyElement(TAProperty property) {
        Element element;
        if (!this.perCharacter3D) {
            switch (property) {
                case rotationX: 
                case rotationY: {
                    return null;
                }
            }
        }
        if ((element = this.childrenMap.get(property)) != null) {
            return element;
        }
        String label = EnumLabels.getLabel(property);
        switch (property) {
            case anchorPoint: 
            case position: {
                element = this.perCharacter3D ? this.createAnimatableVec3dElement(property.name(), label, null) : this.createTiny2DManipVec3dElement(property.name(), label);
                break;
            }
            case scale: {
                element = this.createScaleElement(property.name(), label, "%");
                break;
            }
            case rotationZ: {
                if (!this.perCharacter3D) {
                    label = "\u56de\u8ee2";
                }
            }
            case skewAxis: 
            case rotationX: 
            case rotationY: 
            case fillHue: 
            case strokeHue: {
                element = this.createAngleElement(property.name(), label, "\u00b0");
                break;
            }
            case opacity: 
            case fillSaturation: 
            case fillLuminosity: 
            case fillOpacity: 
            case strokeSaturation: 
            case strokeLuminosity: 
            case strokeOpacity: {
                element = this.createPropertyElement(property.name(), label, "%");
                break;
            }
            case skew: 
            case fillRGB: 
            case strokeRGB: 
            case strokeWidth: 
            case tracking: 
            case lineSpacing: 
            case characterRange: 
            case characterValue: 
            case characterOffset: {
                element = this.createPropertyElement(property.name(), label);
                break;
            }
            case blur: {
                element = this.createBlurElement(property.name(), label);
                break;
            }
            default: {
                throw new RuntimeException("unknown TAProperty: " + property);
            }
        }
        this.childrenMap.put(property, element);
        return element;
    }

    private LayerAnimatableValueElement createPropertyElement(String property, String name, String unit) {
        return new TAPropertyAnimatableValueElement(property, name, unit);
    }

    private LayerAnimatableValueElement createPropertyElement(String property, String name) {
        return this.createPropertyElement(property, name, null);
    }

    private LayerAnimatableValueElement createTiny2DManipVec3dElement(String property, String name) {
        return new TAPropertyAnimatableValueElement(property, name, null){

            @Override
            protected AnimatableValueElementDelegate<?> createDelegate() {
                AnimatableVec3d avalue = (AnimatableVec3d)PropertyUtil.getProperty(this.layer, this.getProperty());
                return new Tiny2DManipVec3dElementDelegate((AnimatableValueElement)this, this.name, avalue);
            }
        };
    }

    private LayerAnimatableValueElement createAnimatableVec3dElement(String property, String name, String unit) {
        return new TAPropertyAnimatableValueElement(property, name, unit){

            @Override
            protected AnimatableValueElementDelegate<?> createDelegate() {
                AnimatableVec3d avalue = (AnimatableVec3d)PropertyUtil.getProperty(this.layer, this.getProperty());
                return new AnimatableVec3dElementDelegate(this, this.name, avalue, TextAnimatorElement.this.perCharacter3D, this.unit);
            }
        };
    }

    private LayerAnimatableValueElement createScaleElement(String property, String name, String unit) {
        return new TAPropertyAnimatableValueElement(property, name, unit){

            @Override
            protected AnimatableValueElementDelegate<?> createDelegate() {
                AnimatableVec3d avalue = (AnimatableVec3d)PropertyUtil.getProperty(this.layer, this.getProperty());
                return new ScaleElementDelegate(this, this.name, avalue, TextAnimatorElement.this.perCharacter3D, this.unit);
            }
        };
    }

    private LayerAnimatableValueElement createAngleElement(String property, String name, String unit) {
        return new TAPropertyAnimatableValueElement(property, name, unit){

            @Override
            protected AnimatableValueElementDelegate<?> createDelegate() {
                AnimatableDouble avalue = (AnimatableDouble)PropertyUtil.getProperty(this.layer, this.getProperty());
                return new AngleElementDelegate(this, this.name, avalue, this.unit);
            }
        };
    }

    private LayerAnimatableValueElement createBlurElement(String property, String name) {
        return new TAPropertyAnimatableValueElement(property, name, null){

            @Override
            protected AnimatableValueElementDelegate<?> createDelegate() {
                AnimatableVec2d avalue = (AnimatableVec2d)PropertyUtil.getProperty(this.layer, this.getProperty());
                return new XYLinkableVec2dElementDelegate(this, this.name, avalue, 1.0, 1, 4, this.unit);
            }
        };
    }

    private void prepareChildren() {
        boolean currentPerCharacter3D;
        this.children.clear();
        TextLayer layer = this.getLayer();
        boolean bl = currentPerCharacter3D = LayerNature.isThreeD((Layer)layer) && layer.isPerCharacter3D();
        if (this.perCharacter3D != currentPerCharacter3D) {
            this.childrenMap.remove(TAProperty.anchorPoint);
            this.childrenMap.remove(TAProperty.position);
            this.childrenMap.remove(TAProperty.scale);
            this.childrenMap.remove(TAProperty.rotationX);
            this.childrenMap.remove(TAProperty.rotationY);
            this.childrenMap.remove(TAProperty.rotationZ);
            this.perCharacter3D = currentPerCharacter3D;
        }
        for (TASelector selector : this.animator.getSelectors()) {
            this.children.add(this.getSelectorElement(selector));
        }
        TAProperty[] tAPropertyArray = TAProperty.values();
        int n = tAPropertyArray.length;
        int n2 = 0;
        while (n2 < n) {
            Element element;
            TAProperty property = tAPropertyArray[n2];
            if (this.animator.getProperties().contains(property) && (element = this.getPropertyElement(property)) != null) {
                this.children.add(element);
            }
            ++n2;
        }
        this.childrenMap.values().retainAll(this.children);
    }

    private class EnableSwitch
    implements Switch {
        private EnableSwitch() {
        }

        public boolean hasBorder() {
            return true;
        }

        public Image getImage() {
            return TextAnimatorElement.this.animator.isEnabled() ? imageRegistry.get("IMG_SWITCH_VIDEO") : null;
        }

        public void mouseDown(MouseEvent event) {
            boolean currentEnabled = TextAnimatorElement.this.animator.isEnabled();
            String label = currentEnabled ? "\u30c6\u30ad\u30b9\u30c8\u30a2\u30cb\u30e1\u30fc\u30bf\u3092\u7121\u52b9\u306b\u3059\u308b" : "\u30c6\u30ad\u30b9\u30c8\u30a2\u30cb\u30e1\u30fc\u30bf\u3092\u6709\u52b9\u306b\u3059\u308b";
            ProjectManager pm = (ProjectManager)TextAnimatorElement.this.viewer.getData("PROJECT_MANAGER");
            TextLayer layer = TextAnimatorElement.this.getLayer();
            String property = String.format("textAnimators[%d].enabled", layer.getTextAnimators().indexOf(TextAnimatorElement.this.animator));
            pm.postOperation(new ModifyLayerPropertyOperation<Boolean>(pm, (Layer)layer, property, !currentEnabled, label));
        }
    }

    private class TAPropertyAnimatableValueElement
    extends LayerAnimatableValueElement {
        private final String property;

        public TAPropertyAnimatableValueElement(String property, String name, String unit) {
            super(TextAnimatorElement.this, (Layer)TextAnimatorElement.this.getLayer(), name, unit);
            this.property = property;
        }

        protected String getDefaultExpression() {
            return String.format("textAnimator(\"%s\").%s", TextAnimatorElement.this.animator.getName().replaceAll("\"", "\\\\\""), this.property);
        }

        public String getProperty() {
            return String.format("textAnimators[%d].%s", ((TextLayer)this.layer).getTextAnimators().indexOf(TextAnimatorElement.this.animator), this.property);
        }
    }
}

