/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.views.layercomp;

import ch.kuramo.javie.api.Vec2d;
import ch.kuramo.javie.app.Activator;
import ch.kuramo.javie.app.views.layercomp.AnimatableValueElement;
import ch.kuramo.javie.app.views.layercomp.AnimatableVec2dElementDelegate;
import ch.kuramo.javie.app.views.layercomp.Switch;
import ch.kuramo.javie.app.views.layercomp.SwitchGroup;
import ch.kuramo.javie.core.AnimatableVec2d;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;

public class XYLinkableVec2dElementDelegate
extends AnimatableVec2dElementDelegate {
    private static final Image linkImage = Activator.getDefault().getImageRegistry().get("IMG_SWITCH_LINK");
    private final SwitchGroup linkSwitch = new SwitchGroup();
    private boolean linked = true;

    public XYLinkableVec2dElementDelegate(AnimatableValueElement element, String name, AnimatableVec2d avalue, double increment, int displayPrecision, int editorPrecision, String unit) {
        super(element, name, avalue, increment, displayPrecision, editorPrecision, unit);
        this.linkSwitch.add(new Switch(){

            public void mouseDown(MouseEvent event) {
                XYLinkableVec2dElementDelegate.this.linked = !XYLinkableVec2dElementDelegate.this.linked;
                XYLinkableVec2dElementDelegate.this.linkSwitch.redraw((Control)event.widget);
            }

            public boolean hasBorder() {
                return true;
            }

            public Image getImage() {
                return XYLinkableVec2dElementDelegate.this.linked ? linkImage : null;
            }
        });
    }

    public void paintColumn(Event event) {
        if (event.index == 1) {
            this.linkSwitch.paint(event);
        }
        super.paintColumn(event);
    }

    protected void drawValue(GC gc, int x, int y, int height, boolean focused) {
        super.drawValue(gc, x + 18, y, height, focused);
    }

    protected int drawValue(GC gc, int x, int y, int height, int valueIndex, double value) {
        return super.drawValue(gc, valueIndex == 0 ? x + 18 : x, y, height, valueIndex, value);
    }

    public void mouseDown(MouseEvent event, int columnIndex) {
        if (columnIndex == 1) {
            this.linkSwitch.mouseDown(event);
        }
        super.mouseDown(event, columnIndex);
    }

    public CellEditor getCellEditor(int columnIndex) {
        if (columnIndex == 1) {
            if (this.editor == null) {
                this.editor = new XYLinkableCellEditor((Composite)this.element.viewer.getTree(), 2052);
            }
            return this.editor;
        }
        return null;
    }

    protected void modifyValue(Vec2d newValue, String relation) {
        if (this.linked) {
            double[] oldArray = new double[]{((Vec2d)this.value).x, ((Vec2d)this.value).y};
            double[] newArray = new double[]{newValue.x, newValue.y};
            double ratio = newArray[this.valueIndex] / oldArray[this.valueIndex];
            int i = 0;
            while (i < 2) {
                if (i != this.valueIndex) {
                    if (oldArray[i] == oldArray[this.valueIndex]) {
                        newArray[i] = newArray[this.valueIndex];
                    } else if (!Double.isNaN(ratio) && !Double.isInfinite(ratio)) {
                        int n = i;
                        newArray[n] = newArray[n] * ratio;
                    }
                }
                ++i;
            }
            newValue = new Vec2d(newArray[0], newArray[1]);
        }
        super.modifyValue(newValue, relation);
    }

    protected class XYLinkableCellEditor
    extends AnimatableVec2dElementDelegate.Vec2dCellEditor {
        protected XYLinkableCellEditor(Composite parent, int style) {
            super(parent, style);
        }

        protected Control createControl(Composite parent) {
            Control control = super.createControl(parent);
            FormData data = (FormData)this.text.getLayoutData();
            data.left.offset += 18;
            data.right.offset += 18;
            if (WIN32) {
                control.addPaintListener(new PaintListener(){

                    public void paintControl(PaintEvent e) {
                        Event event = new Event();
                        event.gc = e.gc;
                        event.widget = e.widget;
                        event.x = e.x;
                        event.y = e.y;
                        XYLinkableVec2dElementDelegate.this.linkSwitch.paint(event);
                    }
                });
            }
            return control;
        }
    }
}

