/*
 * Copyright (c) 2009 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.app;

import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.LoaderClassPath;
import javassist.NotFoundException;
import javassist.expr.ExprEditor;
import javassist.expr.MethodCall;

import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DND;

import ch.kuramo.javie.core.JavieRuntimeException;

public class DropTargetEnhancement {

	public static final int FEEDBACK_PARENT = 32;


	public static void patch() {
		String platform = SWT.getPlatform();

		if (platform.equals("cocoa")) {
			cocoa();
		} else if (platform.equals("win32")) {
			win32();
		}
	}

	private static void cocoa() {
		try {
			ClassLoader loader = DND.class.getClassLoader();

			ClassPool pool = new ClassPool();
			pool.appendClassPath(new LoaderClassPath(loader));
			CtClass targetClass = pool.get("org.eclipse.swt.dnd.DropTarget");

			CtMethod method = targetClass.getDeclaredMethod("outlineView_validateDrop_proposedItem_proposedChildIndex");
			method.instrument(new ExprEditor() {
				public void edit(MethodCall m) throws CannotCompileException {
					if (m.getClassName().equals("org.eclipse.swt.widgets.Tree") && m.getMethodName().equals("getItem")) {
						String src = "org.eclipse.swt.widgets.TreeItem tmpItem = $proceed($$);"
								   + "if ((feedback & %d) != 0 && tmpItem != null) { $_ = tmpItem.getParentItem(); }"
								   + "else { $_ = tmpItem; }";
						m.replace(String.format(src, FEEDBACK_PARENT));
					}
				}
			});

			targetClass.toClass(loader, null);

		} catch (NotFoundException e) {
			throw new JavieRuntimeException(e);
		} catch (CannotCompileException e) {
			throw new JavieRuntimeException(e);
		}
	}

	private static void win32() {
		try {
			ClassLoader loader = DND.class.getClassLoader();

			ClassPool pool = new ClassPool();
			pool.appendClassPath(new LoaderClassPath(loader));
			CtClass targetClass = pool.get("org.eclipse.swt.dnd.TreeDropTargetEffect");

			CtMethod method = targetClass.getDeclaredMethod("dragOver");
			method.instrument(new ExprEditor() {
				private boolean done;

				public void edit(MethodCall m) throws CannotCompileException {
					if (!done && m.getClassName().equals("org.eclipse.swt.internal.win32.OS")
							&& m.getMethodName().equals("SendMessage")) {

						String src =
								"$_ = $proceed($$);" +
								"if ((effect & %d) != 0 && lpht.hItem != -1) {" +
								"	org.eclipse.swt.widgets.TreeItem item = (org.eclipse.swt.widgets.TreeItem)" +
								"			tree.getDisplay().findWidget(tree.handle, lpht.hItem);" +
								"	if (item != null) {" +
								"		item = item.getParentItem();" +
								"		lpht.hItem = (item != null) ? item.handle : -1;" +
								"	}" +
								"}";

						m.replace(String.format(src, FEEDBACK_PARENT));
						done = true;
					}
				}
			});

			targetClass.toClass(loader, null);

		} catch (NotFoundException e) {
			throw new JavieRuntimeException(e);
		} catch (CannotCompileException e) {
			throw new JavieRuntimeException(e);
		}
	}


	private DropTargetEnhancement() { }

}
