/*
 * Copyright (c) 2009-2011 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.app.views.layercomp;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

import ch.kuramo.javie.app.EnumLabels;
import ch.kuramo.javie.core.AnimatableEnum;

public class AnimatableEnumElementDelegate<E extends Enum<E>> extends AnimatableValueElementDelegate<E> {

	private final Class<E> enumType;


	public AnimatableEnumElementDelegate(
			AnimatableValueElement element, String name, AnimatableEnum<E> avalue) {

		super(element, name, avalue);
		enumType = avalue.getEnumType();
	}

	protected void drawValue(GC gc, int x, int y, int height, boolean focused) {
		drawValue(gc, x, y, height, focused, EnumLabels.getLabel(value));
	}

	protected boolean canDragGestureEdit() {
		return false;
	}

	protected E dragGesture(double dx, double dy) {
		throw new UnsupportedOperationException("drag gesture edit is not supported");
	}

	protected void openInPlaceEditor() {
		createMenu().setVisible(true);
	}

	protected Menu createMenu() {
		Rectangle r = valueArea.get(valueIndex);
		Menu menu = element.createPopUpMenu(r.x-5, r.y+r.height+2);

		for (final E e : enumType.getEnumConstants()) {
			if (EnumLabels.insertSeparator(e)) {
				new MenuItem(menu, SWT.SEPARATOR);
			}
			Action action = new Action(EnumLabels.getLabel(e).replaceAll("&", "&&"), IAction.AS_RADIO_BUTTON) {
				public void run() {
					if (e != value) {
						modifyValue(e);
					}
				}
			};
			action.setChecked(e == value);

			ActionContributionItem item = new ActionContributionItem(action);
			item.fill(menu, -1);
			item.getWidget().setData(e);
		}

		return menu;
	}

}
