/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.impl.egl;

import com.jogamp.gluegen.runtime.ProcAddressTable;
import com.jogamp.gluegen.runtime.opengl.GLProcAddressResolver;
import com.jogamp.opengl.impl.GLContextImpl;
import com.jogamp.opengl.impl.GLContextShareSet;
import com.jogamp.opengl.impl.GLDrawableImpl;
import com.jogamp.opengl.impl.egl.EGL;
import com.jogamp.opengl.impl.egl.EGLDrawable;
import com.jogamp.opengl.impl.egl.EGLExt;
import com.jogamp.opengl.impl.egl.EGLExtImpl;
import com.jogamp.opengl.impl.egl.EGLExtProcAddressTable;
import com.jogamp.opengl.impl.egl.EGLGraphicsConfiguration;
import java.nio.ByteBuffer;
import java.util.Map;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;

public abstract class EGLContext
extends GLContextImpl {
    private boolean eglQueryStringInitialized;
    private boolean eglQueryStringAvailable;
    private EGLExt eglExt;
    private EGLExtProcAddressTable eglExtProcAddressTable;

    EGLContext(GLDrawableImpl gLDrawableImpl, GLContext gLContext) {
        super(gLDrawableImpl, gLContext);
    }

    public Object getPlatformGLExtensions() {
        return this.getEGLExt();
    }

    public EGLExt getEGLExt() {
        if (this.eglExt == null) {
            this.eglExt = new EGLExtImpl(this);
        }
        return this.eglExt;
    }

    public final ProcAddressTable getPlatformExtProcAddressTable() {
        return this.eglExtProcAddressTable;
    }

    public final EGLExtProcAddressTable getEGLExtProcAddressTable() {
        return this.eglExtProcAddressTable;
    }

    protected Map getFunctionNameMap() {
        return null;
    }

    protected Map getExtensionNameMap() {
        return null;
    }

    public final boolean isGLReadDrawableAvailable() {
        return true;
    }

    protected void makeCurrentImpl(boolean bl) throws GLException {
        if (0L == ((EGLDrawable)this.drawable).getDisplay()) {
            throw new GLException("drawable not properly initialized, NO DISPLAY: " + this.drawable);
        }
        if (EGL.eglGetCurrentContext() != this.contextHandle && !EGL.eglMakeCurrent(((EGLDrawable)this.drawable).getDisplay(), this.drawable.getHandle(), this.drawableRead.getHandle(), this.contextHandle)) {
            throw new GLException("Error making context 0x" + Long.toHexString(this.contextHandle) + " current: error code " + EGL.eglGetError());
        }
    }

    protected void releaseImpl() throws GLException {
        if (!EGL.eglMakeCurrent(((EGLDrawable)this.drawable).getDisplay(), 0L, 0L, 0L)) {
            throw new GLException("Error freeing OpenGL context 0x" + Long.toHexString(this.contextHandle) + ": error code " + EGL.eglGetError());
        }
    }

    protected void destroyImpl() throws GLException {
        if (!EGL.eglDestroyContext(((EGLDrawable)this.drawable).getDisplay(), this.contextHandle)) {
            throw new GLException("Error destroying OpenGL context 0x" + Long.toHexString(this.contextHandle) + ": error code " + EGL.eglGetError());
        }
    }

    protected long createContextARBImpl(long l, boolean bl, int n, int n2, int n3) {
        return 0L;
    }

    protected void destroyContextARBImpl(long l) {
    }

    protected boolean createImpl() throws GLException {
        EGLContext eGLContext;
        long l;
        long l2;
        GLProfile gLProfile;
        long l3;
        block13: {
            l3 = ((EGLDrawable)this.drawable).getDisplay();
            EGLGraphicsConfiguration eGLGraphicsConfiguration = ((EGLDrawable)this.drawable).getGraphicsConfiguration();
            gLProfile = this.drawable.getGLProfile();
            l2 = eGLGraphicsConfiguration.getNativeConfig();
            l = 0L;
            if (l3 == 0L) {
                throw new GLException("Error: attempted to create an OpenGL context without a display connection");
            }
            if (l2 == 0L) {
                throw new GLException("Error: attempted to create an OpenGL context without a graphics configuration");
            }
            try {
                if (!EGL.eglBindAPI(12448)) {
                    throw new GLException("eglBindAPI to ES failed , error 0x" + Integer.toHexString(EGL.eglGetError()));
                }
            }
            catch (GLException gLException) {
                if (!DEBUG) break block13;
                gLException.printStackTrace();
            }
        }
        if ((eGLContext = (EGLContext)GLContextShareSet.getShareContext(this)) != null && (l = eGLContext.getHandle()) == 0L) {
            throw new GLException("GLContextShareSet returned an invalid OpenGL context");
        }
        int[] nArray = new int[]{12440, -1, 12344};
        if (gLProfile.usesNativeGLES2()) {
            nArray[1] = 2;
        } else if (gLProfile.usesNativeGLES1()) {
            nArray[1] = 1;
        } else {
            throw new GLException("Error creating OpenGL context - invalid GLProfile: " + gLProfile);
        }
        this.contextHandle = EGL.eglCreateContext(l3, l2, l, nArray, 0);
        if (this.contextHandle == 0L) {
            throw new GLException("Error creating OpenGL context: eglDisplay 0x" + Long.toHexString(l3) + ", " + gLProfile + ", error 0x" + Integer.toHexString(EGL.eglGetError()));
        }
        GLContextShareSet.contextCreated(this);
        if (DEBUG) {
            System.err.println(EGLContext.getThreadName() + ": !!! Created OpenGL context 0x" + Long.toHexString(this.contextHandle) + ",\n\twrite surface 0x" + Long.toHexString(this.drawable.getHandle()) + ",\n\tread  surface 0x" + Long.toHexString(this.drawableRead.getHandle()) + ",\n\t" + this + ",\n\tsharing with 0x" + Long.toHexString(l));
        }
        if (!EGL.eglMakeCurrent(((EGLDrawable)this.drawable).getDisplay(), this.drawable.getHandle(), this.drawableRead.getHandle(), this.contextHandle)) {
            throw new GLException("Error making context 0x" + Long.toHexString(this.contextHandle) + " current: error code " + EGL.eglGetError());
        }
        this.setGLFunctionAvailability(true, gLProfile.usesNativeGLES2() ? 2 : 1, 0, 40);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void updateGLXProcAddressTable() {
        AbstractGraphicsConfiguration abstractGraphicsConfiguration = this.drawable.getNativeSurface().getGraphicsConfiguration().getNativeGraphicsConfiguration();
        AbstractGraphicsDevice abstractGraphicsDevice = abstractGraphicsConfiguration.getScreen().getDevice();
        String string = abstractGraphicsDevice.getUniqueID();
        if (DEBUG) {
            System.err.println(EGLContext.getThreadName() + ": !!! Initializing EGLextension address table: " + string);
        }
        this.eglQueryStringInitialized = false;
        this.eglQueryStringAvailable = false;
        EGLExtProcAddressTable eGLExtProcAddressTable = null;
        Object object = mappedContextTypeObjectLock;
        synchronized (object) {
            eGLExtProcAddressTable = (EGLExtProcAddressTable)((Object)mappedGLXProcAddress.get(string));
        }
        if (null != eGLExtProcAddressTable) {
            this.eglExtProcAddressTable = eGLExtProcAddressTable;
            if (DEBUG) {
                System.err.println(EGLContext.getThreadName() + ": !!! GLContext EGL ProcAddressTable reusing key(" + string + ") -> " + ((Object)((Object)eGLExtProcAddressTable)).hashCode());
            }
        } else {
            if (this.eglExtProcAddressTable == null) {
                this.eglExtProcAddressTable = new EGLExtProcAddressTable(new GLProcAddressResolver());
            }
            this.resetProcAddressTable(this.getEGLExtProcAddressTable());
            object = mappedContextTypeObjectLock;
            synchronized (object) {
                mappedGLXProcAddress.put(string, this.getEGLExtProcAddressTable());
                if (DEBUG) {
                    System.err.println(EGLContext.getThreadName() + ": !!! GLContext EGL ProcAddressTable mapping key(" + string + ") -> " + ((Object)((Object)this.getEGLExtProcAddressTable())).hashCode());
                }
            }
        }
    }

    public synchronized String getPlatformExtensionsString() {
        if (!this.eglQueryStringInitialized) {
            this.eglQueryStringAvailable = this.getDrawableImpl().getGLDynamicLookupHelper().dynamicLookupFunction("eglQueryString") != 0L;
            this.eglQueryStringInitialized = true;
        }
        if (this.eglQueryStringAvailable) {
            String string = EGL.eglQueryString(((EGLDrawable)this.drawable).getDisplay(), 12373);
            if (DEBUG) {
                System.err.println("!!! EGL extensions: " + string);
            }
            return string;
        }
        return "";
    }

    protected void setSwapIntervalImpl(int n) {
        if (EGL.eglSwapInterval(((EGLDrawable)this.drawable).getDisplay(), n)) {
            this.currentSwapInterval = n;
        }
    }

    public abstract void bindPbufferToTexture();

    public abstract void releasePbufferFromTexture();

    protected void copyImpl(GLContext gLContext, int n) throws GLException {
        throw new GLException("Not yet implemented");
    }

    public ByteBuffer glAllocateMemoryNV(int n, float f, float f2, float f3) {
        throw new GLException("Should not call this");
    }

    public boolean offscreenImageNeedsVerticalFlip() {
        throw new GLException("Should not call this");
    }

    public int getOffscreenContextPixelDataType() {
        throw new GLException("Should not call this");
    }
}

