/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.nativewindow.impl.x11;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.nio.StructAccessor;
import com.jogamp.common.os.Platform;
import com.jogamp.nativewindow.impl.x11.XVisualInfo32;
import com.jogamp.nativewindow.impl.x11.XVisualInfo64;
import java.nio.ByteBuffer;

public abstract class XVisualInfo {
    StructAccessor accessor;

    public static int size() {
        if (Platform.is32Bit()) {
            return XVisualInfo32.size();
        }
        return XVisualInfo64.size();
    }

    public static XVisualInfo create() {
        return XVisualInfo.create(Buffers.newDirectByteBuffer((int)XVisualInfo.size()));
    }

    public static XVisualInfo create(ByteBuffer byteBuffer) {
        if (Platform.is32Bit()) {
            return new XVisualInfo32(byteBuffer);
        }
        return new XVisualInfo64(byteBuffer);
    }

    XVisualInfo(ByteBuffer byteBuffer) {
        this.accessor = new StructAccessor(byteBuffer);
    }

    public ByteBuffer getBuffer() {
        return this.accessor.getBuffer();
    }

    public abstract XVisualInfo setVisualid(long var1);

    public abstract long getVisualid();

    public abstract XVisualInfo setScreen(int var1);

    public abstract int getScreen();

    public abstract XVisualInfo setDepth(int var1);

    public abstract int getDepth();

    public abstract XVisualInfo setC_class(int var1);

    public abstract int getC_class();

    public abstract XVisualInfo setRed_mask(long var1);

    public abstract long getRed_mask();

    public abstract XVisualInfo setGreen_mask(long var1);

    public abstract long getGreen_mask();

    public abstract XVisualInfo setBlue_mask(long var1);

    public abstract long getBlue_mask();

    public abstract XVisualInfo setColormap_size(int var1);

    public abstract int getColormap_size();

    public abstract XVisualInfo setBits_per_rgb(int var1);

    public abstract int getBits_per_rgb();

    public static XVisualInfo create(XVisualInfo xVisualInfo) {
        XVisualInfo xVisualInfo2 = XVisualInfo.create();
        xVisualInfo2.getBuffer().put(xVisualInfo.getBuffer());
        xVisualInfo2.getBuffer().rewind();
        xVisualInfo.getBuffer().rewind();
        return xVisualInfo2;
    }
}

