/*
 * Copyright (c) 2011 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.voodoo2javie;

import java.io.File;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;

import ch.kuramo.javie.app.project.ProjectManager;

public class Voodoo2JavieHandler extends AbstractHandler {

	public Object execute(ExecutionEvent event) throws ExecutionException {
		IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked(event);

		ProjectManager pm = ProjectManager.forWorkbenchWindow(window);
		if (pm == null) {
			return null;
		}

		File file = showFileDialog(window);
		if (file == null) {
			return null;
		}

		ProgressMonitorDialog progMonDialog = new ProgressMonitorDialog(window.getShell()) {
			protected int getShellStyle() {
				return super.getShellStyle() | SWT.SHEET;
			}
		};

		Voodoo2Javie v2j = new Voodoo2Javie();
		if (!v2j.readFile(file, progMonDialog)) {
			// TODO
			//String error = v2j.getError();
			//if (error != null) {
			//	MessageDialog.openError(window.getShell(), "エラー", error);
			//}
			return null;
		}

		WizardDialog wizardDialog = new WizardDialog(window.getShell(), new Voodoo2JavieWizard(v2j, pm));
		wizardDialog.open();

		return null;
	}

	private File showFileDialog(IWorkbenchWindow window) {
		String[] filterNames = new String[] { "テキストファイル (*.txt)", "すべてのファイル" };
		String[] filterExtensions = new String[] { "*.txt", "*" };

		String platform = SWT.getPlatform();
		if (platform.equals("win32") || platform.equals("wpf")) {
			filterExtensions[filterExtensions.length-1] = "*.*";
		}

		FileDialog dialog = new FileDialog(window.getShell(), SWT.OPEN | SWT.SHEET);
		dialog.setFilterNames(filterNames);
		dialog.setFilterExtensions(filterExtensions);

		if (dialog.open() == null) {
			return null;
		}

		return new File(dialog.getFilterPath(), dialog.getFileName());
	}

}
