/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.impl;

import com.jogamp.opengl.impl.GLContextImpl;
import com.jogamp.opengl.impl.GLDrawableImpl;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.AbstractGraphicsScreen;

public class SharedResourceRunner
implements Runnable {
    protected static final boolean DEBUG = GLDrawableImpl.DEBUG;
    Implementation impl = null;
    boolean ready = false;
    boolean released = false;
    boolean shouldRelease = false;
    String initConnection = null;
    String releaseConnection = null;
    HashSet devicesTried = new HashSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getDeviceTried(String string) {
        HashSet hashSet = this.devicesTried;
        synchronized (hashSet) {
            return this.devicesTried.contains(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDeviceTried(String string) {
        HashSet hashSet = this.devicesTried;
        synchronized (hashSet) {
            this.devicesTried.add(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeDeviceTried(String string) {
        HashSet hashSet = this.devicesTried;
        synchronized (hashSet) {
            this.devicesTried.remove(string);
        }
    }

    public SharedResourceRunner(Implementation implementation) {
        this.impl = implementation;
    }

    public Resource getOrCreateShared(AbstractGraphicsDevice abstractGraphicsDevice) {
        String string = abstractGraphicsDevice.getConnection();
        Resource resource = this.impl.mapGet(string);
        if (null == resource && !this.getDeviceTried(string)) {
            this.addDeviceTried(string);
            if (DEBUG) {
                System.err.println("getOrCreateShared() " + string + ": trying");
            }
            this.doAndWait(string, null);
            resource = this.impl.mapGet(string);
            if (DEBUG) {
                Throwable throwable = new Throwable("getOrCreateSharedl() " + string + ": done");
                throwable.printStackTrace();
            }
        }
        return resource;
    }

    public Resource releaseShared(AbstractGraphicsDevice abstractGraphicsDevice) {
        String string = abstractGraphicsDevice.getConnection();
        Resource resource = this.impl.mapGet(string);
        if (null != resource) {
            this.removeDeviceTried(string);
            if (DEBUG) {
                System.err.println("releaseShared() " + string + ": trying");
            }
            this.doAndWait(null, string);
            if (DEBUG) {
                Throwable throwable = new Throwable("releaseSharedl() " + string + ": done");
                throwable.printStackTrace();
            }
        }
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void doAndWait(String string, String string2) {
        String string3 = Thread.currentThread().getName();
        if (DEBUG) {
            System.err.println(string3 + " doAndWait START init: " + string + ", release: " + string2);
        }
        SharedResourceRunner sharedResourceRunner = this;
        synchronized (sharedResourceRunner) {
            while (!this.ready) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (DEBUG) {
                System.err.println(string3 + " initializeAndWait set command init: " + string + ", release: " + string2);
            }
            this.initConnection = string;
            this.releaseConnection = string2;
            this.notifyAll();
            while (!this.ready || null != this.initConnection || null != this.releaseConnection) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (DEBUG) {
                System.err.println(string3 + " initializeAndWait END init: " + string + ", release: " + string2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void releaseAndWait() {
        SharedResourceRunner sharedResourceRunner = this;
        synchronized (sharedResourceRunner) {
            this.shouldRelease = true;
            this.notifyAll();
            while (!this.released) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run() {
        String string = Thread.currentThread().getName();
        if (DEBUG) {
            System.err.println(string + " STARTED");
        }
        SharedResourceRunner sharedResourceRunner = this;
        synchronized (sharedResourceRunner) {
            while (!this.shouldRelease) {
                try {
                    this.ready = true;
                    if (DEBUG) {
                        System.err.println(string + " -> ready");
                    }
                    this.notifyAll();
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.ready = false;
                if (!this.shouldRelease) {
                    Resource resource;
                    if (DEBUG) {
                        System.err.println(string + " woke up for device connection init: " + this.initConnection + ", release: " + this.releaseConnection);
                    }
                    if (null != this.initConnection) {
                        if (DEBUG) {
                            System.err.println(string + " create Shared for: " + this.initConnection);
                        }
                        if (null != (resource = this.impl.createSharedResource(this.initConnection))) {
                            this.impl.mapPut(this.initConnection, resource);
                        }
                    }
                    if (null != this.releaseConnection) {
                        if (DEBUG) {
                            System.err.println(string + " release Shared for: " + this.releaseConnection);
                        }
                        if (null != (resource = this.impl.mapPut(this.releaseConnection, null))) {
                            this.impl.releaseSharedResource(resource);
                        }
                    }
                }
                this.initConnection = null;
                this.releaseConnection = null;
            }
            if (DEBUG) {
                System.err.println(string + " release START");
            }
            this.releaseSharedResources();
            if (DEBUG) {
                System.err.println(string + " release END");
            }
            this.released = true;
            this.ready = false;
            this.notifyAll();
        }
    }

    private void releaseSharedResources() {
        Collection collection = this.impl.mapValues();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Resource resource = (Resource)iterator.next();
            this.impl.releaseSharedResource(resource);
        }
        this.impl.clear();
    }

    public static interface Implementation {
        public Resource createSharedResource(String var1);

        public void releaseSharedResource(Resource var1);

        public void clear();

        public Resource mapPut(String var1, Resource var2);

        public Resource mapGet(String var1);

        public Collection mapValues();
    }

    public static interface Resource {
        public AbstractGraphicsDevice getDevice();

        public AbstractGraphicsScreen getScreen();

        public GLDrawableImpl getDrawable();

        public GLContextImpl getContext();
    }
}

