/*
 * Copyright (c) 2011 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ftgl;

import com.sun.jna.Structure;

public class TT_OS2 extends Structure {

	/**
	 * FT_UShort  version;
	 */
	public short version;

	/**
	 * FT_Short   xAvgCharWidth;
	 */
	public short xAvgCharWidth;

	/**
	 * FT_UShort  usWeightClass;
	 */
	public short usWeightClass;

	/**
	 * FT_UShort  usWidthClass;
	 */
	public short usWidthClass;

	/**
	 * FT_Short   fsType;
	 */
	public short fsType;

	/**
	 * FT_Short   ySubscriptXSize;
	 */
	public short ySubscriptXSize;

	/**
	 * FT_Short   ySubscriptYSize;
	 */
	public short ySubscriptYSize;

	/**
	 * FT_Short   ySubscriptXOffset;
	 */
	public short ySubscriptXOffset;

	/**
	 * FT_Short   ySubscriptYOffset;
	 */
	public short ySubscriptYOffset;

	/**
	 * FT_Short   ySuperscriptXSize;
	 */
	public short ySuperscriptXSize;

	/**
	 * FT_Short   ySuperscriptYSize;
	 */
	public short ySuperscriptYSize;

	/**
	 * FT_Short   ySuperscriptXOffset;
	 */
	public short ySuperscriptXOffset;

	/**
	 * FT_Short   ySuperscriptYOffset;
	 */
	public short ySuperscriptYOffset;

	/**
	 * FT_Short   yStrikeoutSize;
	 */
	public short yStrikeoutSize;

	/**
	 * FT_Short   yStrikeoutPosition;
	 */
	public short yStrikeoutPosition;

	/**
	 * FT_Short   sFamilyClass;
	 */
	public short sFamilyClass;

	/**
	 * FT_Byte    panose[10];
	 */
	public byte[] panose = new byte[10];

	/**
	 * FT_ULong   ulUnicodeRange1;
	 */
	public int ulUnicodeRange1;

	/**
	 * FT_ULong   ulUnicodeRange2;
	 */
	public int ulUnicodeRange2;

	/**
	 * FT_ULong   ulUnicodeRange3;
	 */
	public int ulUnicodeRange3;

	/**
	 * FT_ULong   ulUnicodeRange4;
	 */
	public int ulUnicodeRange4;

	/**
	 * FT_Char    achVendID[4];
	 */
	public byte[] achVendID = new byte[4];

	/**
	 * FT_UShort  fsSelection;
	 */
	public short fsSelection;

	/**
	 * FT_UShort  usFirstCharIndex;
	 */
	public short usFirstCharIndex;

	/**
	 * FT_UShort  usLastCharIndex;
	 */
	public short usLastCharIndex;

	/**
	 * FT_Short   sTypoAscender;
	 */
	public short sTypoAscender;

	/**
	 * FT_Short   sTypoDescender;
	 */
	public short sTypoDescender;

	/**
	 * FT_Short   sTypoLineGap;
	 */
	public short sTypoLineGap;

	/**
	 * FT_UShort  usWinAscent;
	 */
	public short usWinAscent;

	/**
	 * FT_UShort  usWinDescent;
	 */
	public short usWinDescent;

	/**
	 * FT_ULong   ulCodePageRange1;
	 */
	public int ulCodePageRange1;

	/**
	 * FT_ULong   ulCodePageRange2;
	 */
	public int ulCodePageRange2;

	/**
	 * FT_Short   sxHeight;
	 */
	public short sxHeight;

	/**
	 * FT_Short   sCapHeight;
	 */
	public short sCapHeight;

	/**
	 * FT_UShort  usDefaultChar;
	 */
	public short usDefaultChar;

	/**
	 * FT_UShort  usBreakChar;
	 */
	public short usBreakChar;

	/**
	 * FT_UShort  usMaxContext;
	 */
	public short usMaxContext;

}
