/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.util;

public class RunnableTask
implements Runnable {
    Runnable runnable;
    Object notifyObject;
    boolean catchExceptions;
    Object attachment;
    Throwable runnableException;
    long ts0;
    long ts1;
    long ts2;

    public RunnableTask(Runnable runnable) {
        this(runnable, null, false);
    }

    public RunnableTask(Runnable runnable, Object notifyObject) {
        this(runnable, notifyObject, false);
    }

    public RunnableTask(Runnable runnable, Object notifyObject, boolean catchExceptions) {
        this.runnable = runnable;
        this.notifyObject = notifyObject;
        this.catchExceptions = catchExceptions;
        this.ts0 = System.currentTimeMillis();
        this.ts1 = 0L;
        this.ts2 = 0L;
    }

    public Runnable getRunnable() {
        return this.runnable;
    }

    public void setAttachment(Object o) {
        this.attachment = o;
    }

    public Object getAttachment() {
        return this.attachment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run() {
        this.ts1 = System.currentTimeMillis();
        if (null == this.notifyObject) {
            try {
                this.runnable.run();
                return;
            }
            catch (Throwable t) {
                this.runnableException = t;
                if (this.catchExceptions) return;
                throw new RuntimeException(this.runnableException);
            }
            finally {
                this.ts2 = System.currentTimeMillis();
            }
        }
        Object object = this.notifyObject;
        synchronized (object) {
            try {
                this.runnable.run();
            }
            catch (Throwable t) {
                this.runnableException = t;
                if (this.catchExceptions) return;
                throw new RuntimeException(this.runnableException);
            }
            finally {
                this.ts2 = System.currentTimeMillis();
                this.notifyObject.notifyAll();
            }
            return;
        }
    }

    public boolean isExecuted() {
        return 0L != this.ts2;
    }

    public Throwable getThrowable() {
        return this.runnableException;
    }

    public long getTimestampCreate() {
        return this.ts0;
    }

    public long getTimestampBeforeExec() {
        return this.ts1;
    }

    public long getTimestampAfterExec() {
        return this.ts2;
    }

    public long getDurationInQueue() {
        return this.ts1 - this.ts0;
    }

    public long getDurationInExec() {
        return this.ts2 - this.ts1;
    }

    public long getDurationTotal() {
        return this.ts2 - this.ts0;
    }

    public String toString() {
        return "RunnableTask[executed " + this.isExecuted() + ", t2-t0 " + this.getDurationTotal() + ", t2-t1 " + this.getDurationInExec() + ", t1-t0 " + this.getDurationInQueue() + ", throwable " + this.getThrowable() + ", Runnable " + this.runnable + ", Attachment " + this.attachment + "]";
    }
}

