/*
 * Copyright (c) 2009,2010 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.api;

/**
 * <p>
 * アニメーション可能な<code>Double</code>型のプロパティを表すインターフェースです。
 * このインターフェースは <i>不透明型</i> であり、メソッド等はありません。
 * </p>
 * <hr>
 * <p>
 * 次のコードは、<code>IAnimatableDouble</code> の使用例です。
 * 他のアニメーション可能プロパティも同じように使用します ({@link IAnimatableLayerReference} を除く) 。
 * <blockquote><pre>
 *  &#64;Effect
 *  public class ChromaKey {
 *  
 *  	<b>// アニメーション可能なプロパティの宣言
 *  	&#64;Property
 *  	private IAnimatableDouble similarity;</b>
 *  
 *  	private final IVideoEffectContext context;
 *  
 *  	&#64;Inject
 *  	public ChromaKey(IVideoEffectContext context) {
 *  		this.context = context;
 *  	}
 *  
 *  	public IVideoBuffer doVideoEffect() {
 *  		<b>// アニメーション可能なプロパティの現在時刻における値
 *  		double similarity = context.value(this.similarity);</b>
 *  		...
 *  	}
 *  }
 * </pre></blockquote>
 * </p>
 * 
 * <p>
 * {@link IAnimatableLayerReference} の場合は次のように使用します。
 * <blockquote><pre>
 *  &#64;Effect
 *  public class GradientWipe {
 *  
 *  	<b>// アニメーション可能なレイヤー参照プロパティの宣言
 *  	&#64;Property
 *  	private IAnimatableLayerReference gradientLayer;</b>
 *  
 *  	private final IVideoEffectContext context;
 *  
 *  	&#64;Inject
 *  	public GradientWipe(IVideoEffectContext context) {
 *  		this.context = context;
 *  	}
 *  
 *  	public IVideoBuffer doVideoEffect() {
 *  		<b>// アニメーション可能なレイヤー参照プロパティが
 *  		// 現在時刻において参照しているレイヤーの画像を取得する
 *  		IVideoBuffer gradientBuffer = context.getLayerVideoFrame(gradientLayer);</b>
 *  		...
 *  	}
 *  }
 * </pre></blockquote>
 * </p>
 */
public interface IAnimatableDouble extends IAnimatableValue<Double> {

}
