/*
 * Copyright (c) 2009,2010 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.api.services;

import ch.kuramo.javie.api.GeometryInputType;
import ch.kuramo.javie.api.GeometryOutputType;
import ch.kuramo.javie.api.IShaderProgram;
import ch.kuramo.javie.api.ShaderType;

/**
 * <code>IShaderRegistry</code> は {@link IShaderProgram} オブジェクトを管理するサービスです。
 */
public interface IShaderRegistry {

	/**
	 * <code>IShaderProgram</code> オブジェクトを取得します。
	 * 
	 * @param name 取得する <code>IShaderProgram</code> の名前
	 * @return	引数 <code>name</code> で指定した名前を持つ <code>IShaderProgram</code> オブジェクト。
	 * 			指定した名前の <code>IShaderProgram</code> オブジェクトが存在しない場合は <code>null</code>
	 */
	IShaderProgram getProgram(String name);

	/**
	 * <code>IShaderProgram</code> オブジェクトを取得します。
	 * このメソッドは {@link #getProgram(String) getProgram}<code>(clazz.getName()+"."+name)</code> と同じです。
	 * 通常、引数 <code>clazz</code> には注釈 &#64;{@link ch.kuramo.javie.api.annotations.ShaderSource}
	 * を付けたフィールドを含むクラス、引数 <code>name</code> にはそのフィールド名を指定します。 
	 * 
	 * @param clazz 取得する <code>IShaderProgram</code> の名前のクラス名部分にあたる <code>Class</code> オブジェクト
	 * @param name 取得する <code>IShaderProgram</code> の名前のフィールド名部分
	 * @return	引数 <code>clazz</code> と <code>name</code> で指定した名前を持つ <code>IShaderProgram</code> オブジェクト。
	 * 			指定した名前の <code>IShaderProgram</code> オブジェクトが存在しない場合は <code>null</code>
	 */
	IShaderProgram getProgram(Class<?> clazz, String name);

	/**
	 * @since 0.5.1
	 */
	IShaderProgram registerProgram(String name, ShaderType type, String[] attach, String[] source);

	/**
	 * @since 0.5.1
	 */
	IShaderProgram registerProgramWithGeometryShader(
			String name, String[] attach, String[] source,
			GeometryInputType inputType, GeometryOutputType outputType, int verticesOut);

	/**
	 * @since 0.5.1
	 */
	boolean isShaderRegistered(String name);

	/**
	 * @since 0.5.1
	 */
	void registerShader(String name, ShaderType type, String[] source);

	/**
	 * @since 0.5.1
	 */
	void registerGeometryShader(String name, String[] source,
			GeometryInputType inputType, GeometryOutputType outputType, int verticesOut);

}
