/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.impl.egl;

import com.jogamp.common.nio.PointerBuffer;
import com.jogamp.opengl.impl.Debug;
import com.jogamp.opengl.impl.egl.EGL;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.AbstractGraphicsScreen;
import javax.media.nativewindow.CapabilitiesChooser;
import javax.media.nativewindow.CapabilitiesImmutable;
import javax.media.nativewindow.DefaultGraphicsConfiguration;
import javax.media.nativewindow.GraphicsConfigurationFactory;
import javax.media.nativewindow.egl.EGLGraphicsDevice;
import javax.media.opengl.DefaultGLCapabilitiesChooser;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesChooser;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;

public class EGLGraphicsConfiguration
extends DefaultGraphicsConfiguration
implements Cloneable {
    protected static final boolean DEBUG = Debug.debug("GraphicsConfiguration");
    private GLCapabilitiesChooser chooser;
    private long config;
    private int configID;

    public long getNativeConfig() {
        return this.config;
    }

    public int getNativeConfigID() {
        return this.configID;
    }

    EGLGraphicsConfiguration(AbstractGraphicsScreen abstractGraphicsScreen, GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesImmutable gLCapabilitiesImmutable2, GLCapabilitiesChooser gLCapabilitiesChooser, long l, int n) {
        super(abstractGraphicsScreen, (CapabilitiesImmutable)gLCapabilitiesImmutable, (CapabilitiesImmutable)gLCapabilitiesImmutable2);
        this.chooser = gLCapabilitiesChooser;
        this.config = l;
        this.configID = n;
    }

    public static EGLGraphicsConfiguration create(GLCapabilitiesImmutable gLCapabilitiesImmutable, AbstractGraphicsScreen abstractGraphicsScreen, int n) {
        AbstractGraphicsDevice abstractGraphicsDevice = abstractGraphicsScreen.getDevice();
        if (null == abstractGraphicsDevice || !(abstractGraphicsDevice instanceof EGLGraphicsDevice)) {
            throw new GLException("GraphicsDevice must be a valid EGLGraphicsDevice");
        }
        long l = abstractGraphicsDevice.getHandle();
        if (l == 0L) {
            throw new GLException("Invalid EGL display: " + abstractGraphicsDevice);
        }
        GLProfile gLProfile = gLCapabilitiesImmutable.getGLProfile();
        long l2 = EGLGraphicsConfiguration.EGLConfigId2EGLConfig(gLProfile, l, n);
        GLCapabilitiesImmutable gLCapabilitiesImmutable2 = EGLGraphicsConfiguration.EGLConfig2Capabilities(gLProfile, l, l2, false, gLCapabilitiesImmutable.isOnscreen(), gLCapabilitiesImmutable.isPBuffer());
        return new EGLGraphicsConfiguration(abstractGraphicsScreen, gLCapabilitiesImmutable2, gLCapabilitiesImmutable, new DefaultGLCapabilitiesChooser(), l2, n);
    }

    public Object clone() {
        return super.clone();
    }

    void updateGraphicsConfiguration() {
        EGLGraphicsConfiguration eGLGraphicsConfiguration = (EGLGraphicsConfiguration)GraphicsConfigurationFactory.getFactory((AbstractGraphicsDevice)this.getScreen().getDevice()).chooseGraphicsConfiguration(this.getChosenCapabilities(), this.getRequestedCapabilities(), (CapabilitiesChooser)this.chooser, this.getScreen());
        if (null != eGLGraphicsConfiguration) {
            this.setChosenCapabilities(eGLGraphicsConfiguration.getChosenCapabilities());
            this.config = eGLGraphicsConfiguration.getNativeConfig();
            this.configID = eGLGraphicsConfiguration.getNativeConfigID();
            if (DEBUG) {
                System.err.println("!!! updateGraphicsConfiguration: " + this);
            }
        }
    }

    public static long EGLConfigId2EGLConfig(GLProfile gLProfile, long l, int n) {
        int[] nArray;
        int[] nArray2 = new int[]{12328, n, 12344};
        PointerBuffer pointerBuffer = PointerBuffer.allocateDirect((int)1);
        if (!EGL.eglChooseConfig(l, nArray2, 0, pointerBuffer, 1, nArray = new int[1], 0)) {
            return 0L;
        }
        if (nArray[0] == 0) {
            return 0L;
        }
        return pointerBuffer.get(0);
    }

    static boolean EGLConfigDrawableTypeVerify(int n, boolean bl, boolean bl2) {
        boolean bl3 = bl ? 0 != (n & 4) : (bl2 ? 0 != (n & 1) : 0 != (n & 2));
        return bl3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GLCapabilitiesImmutable EGLConfig2Capabilities(GLProfile gLProfile, long l, long l2, boolean bl, boolean bl2, boolean bl3) {
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        int[] nArray = new int[1];
        if (EGL.eglGetConfigAttrib(l, l2, 12324, nArray, 0)) {
            gLCapabilities.setRedBits(nArray[0]);
        }
        if (EGL.eglGetConfigAttrib(l, l2, 12323, nArray, 0)) {
            gLCapabilities.setGreenBits(nArray[0]);
        }
        if (EGL.eglGetConfigAttrib(l, l2, 12322, nArray, 0)) {
            gLCapabilities.setBlueBits(nArray[0]);
        }
        if (EGL.eglGetConfigAttrib(l, l2, 12321, nArray, 0)) {
            gLCapabilities.setAlphaBits(nArray[0]);
        }
        if (EGL.eglGetConfigAttrib(l, l2, 12326, nArray, 0)) {
            gLCapabilities.setStencilBits(nArray[0]);
        }
        if (EGL.eglGetConfigAttrib(l, l2, 12325, nArray, 0)) {
            gLCapabilities.setDepthBits(nArray[0]);
        }
        if (EGL.eglGetConfigAttrib(l, l2, 12337, nArray, 0)) {
            gLCapabilities.setSampleBuffers(nArray[0] > 0);
            gLCapabilities.setNumSamples(nArray[0]);
        }
        if (EGL.eglGetConfigAttrib(l, l2, 12340, nArray, 0)) {
            gLCapabilities.setBackgroundOpaque(nArray[0] != 12370);
        }
        if (!gLCapabilities.isBackgroundOpaque()) {
            if (EGL.eglGetConfigAttrib(l, l2, 12343, nArray, 0)) {
                gLCapabilities.setTransparentRedValue(nArray[0] == -1 ? -1 : nArray[0]);
            }
            if (EGL.eglGetConfigAttrib(l, l2, 12342, nArray, 0)) {
                gLCapabilities.setTransparentGreenValue(nArray[0] == -1 ? -1 : nArray[0]);
            }
            if (EGL.eglGetConfigAttrib(l, l2, 12341, nArray, 0)) {
                gLCapabilities.setTransparentBlueValue(nArray[0] == -1 ? -1 : nArray[0]);
            }
        }
        if (!EGL.eglGetConfigAttrib(l, l2, 12339, nArray, 0)) throw new GLException("Could not determine EGL_SURFACE_TYPE !!!");
        if (EGLGraphicsConfiguration.EGLConfigDrawableTypeVerify(nArray[0], bl2, bl3)) {
            gLCapabilities.setDoubleBuffered(bl2);
            gLCapabilities.setOnscreen(bl2);
            gLCapabilities.setPBuffer(bl3);
            return gLCapabilities;
        } else if (bl) {
            gLCapabilities.setDoubleBuffered(0 != (nArray[0] & 4));
            gLCapabilities.setOnscreen(0 != (nArray[0] & 4));
            gLCapabilities.setPBuffer(0 != (nArray[0] & 1));
            return gLCapabilities;
        } else {
            if (!DEBUG) return null;
            System.err.println("EGL_SURFACE_TYPE does not match: req(onscrn " + bl2 + ", pbuffer " + bl3 + "), got(onscreen " + (0 != (nArray[0] & 4)) + ", pbuffer " + (0 != (nArray[0] & 1)) + ", pixmap " + (0 != (nArray[0] & 2)) + ")");
            return null;
        }
    }

    public static int[] GLCapabilities2AttribList(GLCapabilitiesImmutable gLCapabilitiesImmutable) {
        int[] nArray = new int[32];
        int n = 0;
        nArray[n++] = 12339;
        nArray[n++] = gLCapabilitiesImmutable.isOnscreen() ? 4 : (gLCapabilitiesImmutable.isPBuffer() ? 1 : 2);
        nArray[n++] = 12324;
        nArray[n++] = gLCapabilitiesImmutable.getRedBits();
        nArray[n++] = 12323;
        nArray[n++] = gLCapabilitiesImmutable.getGreenBits();
        nArray[n++] = 12322;
        nArray[n++] = gLCapabilitiesImmutable.getBlueBits();
        nArray[n++] = 12321;
        nArray[n++] = gLCapabilitiesImmutable.getAlphaBits() > 0 ? gLCapabilitiesImmutable.getAlphaBits() : -1;
        nArray[n++] = 12326;
        nArray[n++] = gLCapabilitiesImmutable.getStencilBits() > 0 ? gLCapabilitiesImmutable.getStencilBits() : -1;
        nArray[n++] = 12325;
        nArray[n++] = gLCapabilitiesImmutable.getDepthBits();
        nArray[n++] = 12337;
        nArray[n++] = gLCapabilitiesImmutable.getSampleBuffers() ? gLCapabilitiesImmutable.getNumSamples() : 1;
        nArray[n++] = 12340;
        int n2 = nArray[n++] = gLCapabilitiesImmutable.isBackgroundOpaque() ? 12344 : 12340;
        if (!gLCapabilitiesImmutable.isBackgroundOpaque()) {
            nArray[n++] = 12343;
            nArray[n++] = gLCapabilitiesImmutable.getTransparentRedValue() >= 0 ? gLCapabilitiesImmutable.getTransparentRedValue() : -1;
            nArray[n++] = 12342;
            nArray[n++] = gLCapabilitiesImmutable.getTransparentGreenValue() >= 0 ? gLCapabilitiesImmutable.getTransparentGreenValue() : -1;
            nArray[n++] = 12341;
            nArray[n++] = gLCapabilitiesImmutable.getTransparentBlueValue() >= 0 ? gLCapabilitiesImmutable.getTransparentBlueValue() : -1;
        }
        nArray[n++] = 12352;
        nArray[n++] = gLCapabilitiesImmutable.getGLProfile().usesNativeGLES1() ? 1 : (gLCapabilitiesImmutable.getGLProfile().usesNativeGLES2() ? 4 : 8);
        nArray[n++] = 12344;
        return nArray;
    }

    public static int[] CreatePBufferSurfaceAttribList(int n, int n2, int n3) {
        int[] nArray = new int[16];
        int n4 = 0;
        nArray[n4++] = 12375;
        nArray[n4++] = n;
        nArray[n4++] = 12374;
        nArray[n4++] = n2;
        nArray[n4++] = 12416;
        nArray[n4++] = n3;
        nArray[n4++] = 12417;
        nArray[n4++] = 12380 == n3 ? 12380 : 12383;
        nArray[n4++] = 12344;
        return nArray;
    }

    public String toString() {
        return this.getClass().toString() + "[" + this.getScreen() + ", eglConfigID 0x" + Integer.toHexString(this.configID) + ",\n\trequested " + this.getRequestedCapabilities() + ",\n\tchosen    " + this.getChosenCapabilities() + "]";
    }
}

