/*
 * Decompiled with CFR 0.152.
 */
package com.iabcinc.mapping.voronoi;

import com.iabcinc.common.Flagable;
import com.iabcinc.mapping.voronoi.Bounds;
import com.iabcinc.mapping.voronoi.Point;
import com.iabcinc.mapping.voronoi.QuadEdge;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VoronoiPolygon
implements Flagable {
    private LinkedList<QuadEdge> edges;
    private boolean isInnerOuterDetermined = false;
    private boolean isInnerFlag = false;
    private Bounds bounds = new Bounds();

    VoronoiPolygon() {
        this.edges = new LinkedList();
    }

    void add(QuadEdge edge) {
        this.edges.add(edge);
        this.bounds.include(edge.getOrg());
    }

    public boolean contains(Point pt) {
        if (!this.bounds.contains(pt)) {
            return false;
        }
        boolean inside = false;
        for (QuadEdge edge : this.edges) {
            if (!(edge.getDest().getY() <= pt.getY() && pt.getY() < edge.getOrg().getY()) && (!(edge.getOrg().getY() <= pt.getY()) || !(pt.getY() < edge.getDest().getY())) || !(pt.getX() < (edge.getOrg().getX() - edge.getDest().getX()) * (pt.getY() - edge.getDest().getY()) / (edge.getOrg().getY() - edge.getDest().getY()) + edge.getDest().getX())) continue;
            inside = !inside;
        }
        return inside;
    }

    public boolean contains(Bounds bounds) {
        if (!this.bounds.contains(bounds)) {
            return false;
        }
        if (!this.bounds.contains(bounds.getLowerRight())) {
            return false;
        }
        if (!this.bounds.contains(bounds.getUpperLeft())) {
            return false;
        }
        return this.contains(bounds.getLowerRight()) && this.contains(bounds.getUpperLeft());
    }

    public boolean contains(VoronoiPolygon polygon) {
        for (QuadEdge edge : polygon.edges) {
            if (this.contains(edge.getOrg())) continue;
            return false;
        }
        return true;
    }

    public LinkedList<QuadEdge> edges() {
        return this.edges;
    }

    public boolean isOuter() {
        if (this.isInnerOuterDetermined) {
            return !this.isInnerFlag;
        }
        double area = 0.0;
        for (QuadEdge edge : this.edges) {
            Point src = edge.getOrg();
            Point dst = edge.getDest();
            area += (src.getY() + dst.getY()) * (src.getX() - dst.getX()) / 2.0;
        }
        this.isInnerFlag = area < 0.0;
        this.isInnerOuterDetermined = true;
        return !this.isInnerFlag;
    }

    @Override
    public void clearFlag(int flag) {
        this.edges.getFirst().invrot().getOrg().clearFlag(flag);
    }

    @Override
    public int getFlag(int mask) {
        return this.edges.getFirst().invrot().getOrg().getFlag(mask);
    }

    @Override
    public int getFlags() {
        return this.edges.getFirst().invrot().getOrg().getFlags();
    }

    @Override
    public boolean isFlagSet(int flag) {
        return this.edges.getFirst().invrot().getOrg().isFlagSet(flag);
    }

    @Override
    public boolean isFlagSet(int flag, int mask) {
        return this.edges.getFirst().invrot().getOrg().isFlagSet(flag, mask);
    }

    @Override
    public void setFlag(int flag, int mask) {
        this.edges.getFirst().invrot().getOrg().setFlag(flag, mask);
    }

    @Override
    public void setFlag(int flag) {
        this.edges.getFirst().invrot().getOrg().setFlag(flag);
    }

    public String getProperty(String key) {
        return this.edges.getFirst().invrot().getOrg().getProperty(key);
    }
}

