/*
 * Copyright (c) 2011 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.app;

import java.lang.reflect.Method;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ui.splash.AbstractSplashHandler;

public class SplashProgressMonitor {

	private static IProgressMonitor progressMonitor;

	public static IProgressMonitor getProgressMonitor() {
		if (progressMonitor == null) {
			try {
				@SuppressWarnings("restriction")
				Method getSplashMethod = org.eclipse.ui.internal.Workbench.class.getDeclaredMethod("getSplash");
				boolean accessible = getSplashMethod.isAccessible();
				try {
					getSplashMethod.setAccessible(true);
					AbstractSplashHandler splash = (AbstractSplashHandler) getSplashMethod.invoke(null);
					progressMonitor = splash.getBundleProgressMonitor();
				} finally {
					getSplashMethod.setAccessible(accessible);
				}
			} catch (Exception e) {
				progressMonitor = new NullProgressMonitor();
			}
		}
		return progressMonitor;
	}

	public static void beginTask(String name, int totalWork) {
		getProgressMonitor().beginTask(name, totalWork);
	}

	public static void done() {
		getProgressMonitor().done();
	}

	public static void subTask(String name) {
		getProgressMonitor().subTask(name);
	}

	public static void worked(int work) {
		getProgressMonitor().worked(work);
	}

}
