/*
 * Copyright (c) 2010 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.app.actions;

import java.util.Map;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

import ch.kuramo.javie.app.EnumLabels;
import ch.kuramo.javie.app.views.LayerCompositionView;
import ch.kuramo.javie.app.views.layercomp.AnimatableValueElement;
import ch.kuramo.javie.app.views.layercomp.TimelineManager;
import ch.kuramo.javie.core.AnimatableValue;
import ch.kuramo.javie.core.Interpolation;
import ch.kuramo.javie.core.Keyframe;

public class KeyframeInterpolationAction extends Action {

	private final TreeViewer viewer;

	private final Interpolation newInterpolation;


	public KeyframeInterpolationAction(TreeViewer treeViewer, Interpolation interpolation) {
		super(EnumLabels.getLabel(interpolation));
		this.viewer = treeViewer;
		this.newInterpolation = interpolation;

		setEnabled(false);
		setChecked(false);

		Tree tree = treeViewer.getTree();
		final TreeColumn[] columns = tree.getColumns();

		tree.addMouseListener(new MouseAdapter() {
			public void mouseDown(MouseEvent e) {
				boolean enabled = false;
				boolean checked = false;

				int left = 0;
				for (int i = 0; i < columns.length-1; ++i) {
					left += columns[i].getWidth();
				}
				if (left <= e.x && e.x < left + columns[columns.length-1].getWidth()) {
					TimelineManager tm = (TimelineManager) viewer.getData(LayerCompositionView.TIMELINE_MANAGER);
					Map<Keyframe<?>, AnimatableValueElement> selection = tm.getKeyframeSelection();
					if (selection.size() > 0) {
						enabled = true;
						checked = true;
						for (Map.Entry<Keyframe<?>, AnimatableValueElement> entry : selection.entrySet()) {
							AnimatableValueElement avElem = entry.getValue();
							AnimatableValue<?> avalue = avElem.getAnimatableValue();
							enabled &= avalue.getAvailableInterpolations().contains(newInterpolation);
							checked &= (entry.getKey().interpolation == newInterpolation);
						}
					}
				}

				setEnabled(enabled);
				setChecked(checked);
			}
		});
	}

	@Override
	public void run() {
		TimelineManager tm = (TimelineManager) viewer.getData(LayerCompositionView.TIMELINE_MANAGER);
		tm.modifySelectedKeyframeInterpolation(newInterpolation);
	}

}
