/*
 * Copyright (c) 2010 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.app.player;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;

import ch.kuramo.javie.app.ImageUtil;

public class PlayerMuteAction extends Action implements IMenuCreator {

	private final MediaPlayer mediaPlayer;

	private Menu menu;


	public PlayerMuteAction(MediaPlayer mediaPlayer) {
		super("消音");
		this.mediaPlayer = mediaPlayer;

		if (mediaPlayer.hasAudio()) {
			boolean muted = mediaPlayer.isAudioMuted();
			setImageDescriptor(ImageUtil.getPlayerMuteIcon(muted));
			setMenuCreator(this);
		} else {
			setEnabled(false);
			setImageDescriptor(ImageUtil.getPlayerMuteIcon(true));
		}
	}

	public void dispose() {
		disposeMenu();
	}

	private void disposeMenu() {
		if (menu != null) {
			menu.dispose();
			menu = null;
		}
	}

	public Menu getMenu(Control parent) {
		disposeMenu();

		if (!isEnabled()) {
			return null;
		}

		menu = new Menu(parent);


		Action action = new Action("スクラブ中にオーディオを再生する", IAction.AS_CHECK_BOX) {
			{
				setChecked(mediaPlayer.isAudioScrubEnabled());
			}

			public void run() {
				mediaPlayer.setAudioScrubEnabled(!mediaPlayer.isAudioScrubEnabled());
			}
		};

		ActionContributionItem item = new ActionContributionItem(action);
		item.fill(menu, -1);

		return menu;
	}

	public Menu getMenu(Menu parent) {
		return null;
	}

	@Override
	public void run() {
		boolean muted = !mediaPlayer.isAudioMuted();
		mediaPlayer.setAudioMuted(muted);
		setImageDescriptor(ImageUtil.getPlayerMuteIcon(muted));
	}

}
