/*
 * Copyright (c) 2009 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.app.project;

import java.util.LinkedList;
import java.util.ListIterator;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

import ch.kuramo.javie.core.Project;

public class ProjectOperationCollection extends ProjectOperation {

	protected final ProjectManager projectManager;

	protected final LinkedList<ProjectOperation> list = new LinkedList<ProjectOperation>();


	public ProjectOperationCollection(ProjectManager projectManager, String label) {
		super(projectManager, label);
		this.projectManager = projectManager;
	}

	public void add(ProjectOperation operation) {
		if (!operation.projectManagerMatches(projectManager)) {
			throw new IllegalArgumentException("different ProjectManager");
		}
		if (!operation.isNoEffect()) {
			list.add(operation);
		}
	}

	public boolean isEmpty() {
		return list.isEmpty();
	}

	public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
		// redoをただ呼べばいいだけのようにも思えるが、
		// 子のオペレーションがexecuteをオーバーライドしている場合は、
		// 子のexecuteが呼ばれなければならないので、redo任せにしてはならない。

		ListIterator<ProjectOperation> it = list.listIterator();

		IStatus status = Status.OK_STATUS;
		while (status.isOK() && it.hasNext()) {
			status = it.next().execute(monitor, info);
		}

		if (!status.isOK()) {
			while (it.hasPrevious()) {
				IStatus status2 = it.previous().undo(monitor, info);
				if (!status2.isOK()) {
					throw new ExecutionException("a operation returns not OK status and failed to revert");
				}
			}
		}

		return status;
	}

	public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
		ListIterator<ProjectOperation> it = list.listIterator();

		IStatus status = Status.OK_STATUS;
		while (status.isOK() && it.hasNext()) {
			status = it.next().redo(monitor, info);
		}

		if (!status.isOK()) {
			while (it.hasPrevious()) {
				IStatus status2 = it.previous().undo(monitor, info);
				if (!status2.isOK()) {
					throw new ExecutionException("a operation returns not OK status and failed to revert");
				}
			}
		}

		return status;
	}

	public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
		ListIterator<ProjectOperation> it = list.listIterator(list.size());

		IStatus status = Status.OK_STATUS;
		while (status.isOK() && it.hasPrevious()) {
			status = it.previous().undo(monitor, info);
		}

		if (!status.isOK()) {
			while (it.hasNext()) {
				IStatus status2 = it.next().redo(monitor, info);
				if (!status2.isOK()) {
					throw new ExecutionException("a operation returns not OK status and failed to revert");
				}
			}
		}

		return status;
	}

	@Override
	protected IStatus executeOrRedo(IProgressMonitor monitor, IAdaptable info,
			Project project, ProjectManager pm) throws ExecutionException {

		throw new UnsupportedOperationException();
	}

	@Override
	protected IStatus undo(IProgressMonitor monitor, IAdaptable info,
			Project project, ProjectManager pm) throws ExecutionException {

		throw new UnsupportedOperationException();
	}

}
