/*
 * Copyright (c) 2009,2011 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.app.views.layercomp;

import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

import ch.kuramo.javie.app.views.LayerCompositionView;
import ch.kuramo.javie.core.AnimatableBoolean;

public class AnimatableBooleanElementDelegate extends AnimatableValueElementDelegate<Boolean> {

	public AnimatableBooleanElementDelegate(
			AnimatableValueElement element, String name, AnimatableBoolean avalue) {

		super(element, name, avalue);
	}

	protected void drawValue(GC gc, int x, int y, int height, boolean focused) {
		drawValue(gc, x, y, height, focused, valueToDraw ? "オン" : "オフ");
	}

	protected boolean canDragGestureEdit() {
		// FIXME DragGestureEditをサポートすべき。
		return false;
	}

	protected Boolean dragGesture(double dx, double dy) {
		throw new UnsupportedOperationException("drag gesture edit is not supported");
	}

	protected boolean isInPlaceEditorActive() {
		return false;
	}

	public void mouseDown(MouseEvent event, int columnIndex) {
		switch (columnIndex) {
			case LayerCompositionView.VALUE_COL:
				if (event.button == 1) {
					Rectangle r = valueArea.get(0);
					if (r.contains(event.x, event.y)) {
						modifyValue(Boolean.valueOf(!valueWithoutExpr));
					}
				}
				break;

			default:
				super.mouseDown(event, columnIndex);
				break;
		}
	}

}
