/*
 * Copyright (c) 2010,2011 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.app.views.layercomp;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

import ch.kuramo.javie.app.EnumLabels;
import ch.kuramo.javie.core.Layer;

public abstract class LayerEnumPropertyElement<E extends Enum<E>> extends LayerPropertyElement<E> {

	public LayerEnumPropertyElement(Element parent, Layer layer, String label) {
		super(parent, layer, label);
	}

	public LayerEnumPropertyElement(
			Element parent, Layer layer, String label, String operationLabel) {

		super(parent, layer, label, operationLabel);
	}

	@Override
	protected String getValueString() {
		return EnumLabels.getLabel(getValue());
	}

	@Override
	protected void mouseDownOnValueArea() {
		Menu menu = createPopUpMenu(valueArea.x-5, valueArea.y+valueArea.height+2);

		final E value = getValue();
		@SuppressWarnings("unchecked")
		Class<E> enumClass = (Class<E>) value.getClass();

		for (final E e : enumClass.getEnumConstants()) {
			if (EnumLabels.insertSeparator(e)) {
				new MenuItem(menu, SWT.SEPARATOR);
			}
			Action action = new Action(EnumLabels.getLabel(e), IAction.AS_RADIO_BUTTON) {
				public void run() {
					if (e != value) {
						setValue(e);
					}
				}
			};
			action.setChecked(e == value);
			new ActionContributionItem(action).fill(menu, -1);
		}

		menu.setVisible(true);
	}


	protected static class ForSimpleProperty<E extends Enum<E>> extends LayerEnumPropertyElement<E> {

		private final String property;

		public ForSimpleProperty(
				Element parent, Layer layer, String property, String label) {

			super(parent, layer, label);
			this.property = property;
		}

		public ForSimpleProperty(
				Element parent, Layer layer, String property,
				String label, String operationLabel) {

			super(parent, layer, label, operationLabel);
			this.property = property;
		}

		@Override
		public String getProperty() {
			return property;
		}

	}

	public static <E extends Enum<E>> LayerEnumPropertyElement<E> forSimpleProperty(
			Element parent, Layer layer, String property, String label) {

		return new ForSimpleProperty<E>(parent, layer, property, label);
	}

	public static <E extends Enum<E>> LayerEnumPropertyElement<E> forSimpleProperty(
			Element parent, Layer layer, String property,
			String label, String operationLabel) {

		return new ForSimpleProperty<E>(parent, layer, property, label, operationLabel);
	}

}
