/*
 * Copyright (c) 2009,2010 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.core;

import java.util.Collection;

import org.mozilla.javascript.Context;

import ch.kuramo.javie.api.IAnimatableBoolean;
import ch.kuramo.javie.core.expression.BooleanProperty;

public class AnimatableBoolean extends AbstractAnimatableValue<Boolean> implements IAnimatableBoolean {

	public AnimatableBoolean(Boolean staticValue, Collection<Keyframe<Boolean>> keyframes, String expression) {
		super(staticValue, keyframes, expression);
	}

	public AnimatableBoolean(Boolean defaultValue) {
		super(defaultValue);
	}

	public Boolean jsToJava(Object jsValue) {
		return Boolean.valueOf((String) Context.jsToJava(jsValue, String.class));
	}

	public BooleanProperty createExpressionElement(final CoreContext context) {
		return new BooleanProperty() {
			public boolean getValue()				{ return value(context); }
			public boolean valueAtTime(double t)	{ return AnimatableBoolean.this.valueAtTime(t, context); }
		};
	}

}
