/*
 * Copyright (c) 2009,2010 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.core;

import java.util.Collection;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;

import ch.kuramo.javie.api.IAnimatableInteger;
import ch.kuramo.javie.core.expression.IntegerProperty;

public class AnimatableInteger extends ArithmeticalAnimatableValue<Integer> implements IAnimatableInteger {

	public AnimatableInteger(Integer staticValue, Collection<Keyframe<Integer>> keyframes, String expression) {
		super(staticValue, keyframes, expression, Integer.MIN_VALUE, Integer.MAX_VALUE);
	}

	public AnimatableInteger(Integer defaultValue) {
		super(defaultValue, Integer.MIN_VALUE, Integer.MAX_VALUE);
	}

	public AnimatableInteger(Integer defaultValue, Integer minValue, Integer maxValue) {
		super(defaultValue, minValue, maxValue);
	}

	@Override
	public Integer clamp(Integer value) {
		// Math.min/maxを使うと無駄なオブジェクトが生成されるので使わない。
		value = (value < _minValue) ? _minValue : value;
		return (value > _maxValue) ? _maxValue : value;
	}

	public Integer jsToJava(Object jsValue) {
		return (Integer) Context.jsToJava(jsValue, int.class);
	}

	@Override
	protected double[] toArray(Integer value) {
		return new double[] { value.doubleValue() };
	}

	@Override
	protected Integer valueOf(double[] d) {
		return Integer.valueOf(Math.round((float) d[0]));
	}

	public Scriptable createExpressionElement(final CoreContext context) {
		IntegerProperty ip = new IntegerProperty() {
			public int getValue()				{ return value(context); }
			public int valueAtTime(double t)	{ return AnimatableInteger.this.valueAtTime(t, context); }
		};
		return context.toNativeJavaObject(ip, ScriptRuntime.NumberClass);
	}

}
