/*
 * Copyright (c) 2010 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.core;

import java.util.Collection;

import org.mozilla.javascript.Context;

import ch.kuramo.javie.api.IAnimatableLayerReference;
import ch.kuramo.javie.core.expression.StringProperty;

public class AnimatableLayerReference extends AbstractAnimatableValue<String> implements IAnimatableLayerReference {

	public AnimatableLayerReference(String staticValue, Collection<Keyframe<String>> keyframes, String expression) {
		super(staticValue, keyframes, expression);
	}

	public AnimatableLayerReference(String defaultValue) {
		super(defaultValue);
	}

	public String jsToJava(Object jsValue) {
		return (String) Context.jsToJava(jsValue, String.class);
	}

	public StringProperty createExpressionElement(final CoreContext context) {
		return new StringProperty() {
			public String getValue()			{ return value(context); }
			public String valueAtTime(double t)	{ return AnimatableLayerReference.this.valueAtTime(t, context); }
		};
	}

}
